/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.living;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.entity.goal.WizardLookAtTradePlayer;
import com.binaris.wizardry.content.entity.goal.WizardTradeGoal;
import com.binaris.wizardry.content.entity.living.AbstractWizard;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wizard
extends AbstractWizard
implements class_1655,
class_1915 {
    private static final int[] XP_PER_LEVEL = new int[]{0, 10, 70, 150, 250};
    private static final int MAX_LEVEL = 5;
    private static final int MAX_TRADES = 2;
    private class_1916 trades;
    @Nullable
    private class_1657 customer;
    private int timeUntilReset;
    private int wizardXp;
    private int wizardLevel = 1;

    public Wizard(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
    }

    private static int getXpForTier(SpellTier tier) {
        if (tier == SpellTiers.NOVICE) {
            return 2;
        }
        if (tier == SpellTiers.APPRENTICE) {
            return 10;
        }
        if (tier == SpellTiers.ADVANCED) {
            return 20;
        }
        return 50;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new WizardTradeGoal(this));
        this.field_6201.method_6277(1, (class_1352)new WizardLookAtTradePlayer(this));
    }

    public void method_8258(@NotNull class_1799 stack) {
        if (this.method_37908().field_9236 || this.field_6191 <= -this.method_5970() + 20) {
            return;
        }
        this.field_6191 = -this.method_5970();
        class_3414 sound = stack.method_7960() ? EBSounds.ENTITY_WIZARD_NO.get() : (WizardryMainMod.IS_THE_SEASON ? EBSounds.ENTITY_WIZARD_HOHOHO.get() : EBSounds.ENTITY_WIZARD_YES.get());
        this.method_5783(sound, this.method_6107(), this.method_6017());
    }

    protected void method_5958() {
        super.method_5958();
        if (this.isTrading() || this.timeUntilReset < 0) {
            return;
        }
        --this.timeUntilReset;
        if (this.timeUntilReset > 0) {
            return;
        }
        if (this.trades != null) {
            this.trades.stream().filter(class_1914::method_8255).forEach(class_1914::method_19275);
        }
        this.timeUntilReset = -1;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.method_5805() && !this.isTrading() && !this.method_6109() && !player.method_5715() && this.method_5968() != player) {
            if (!this.method_37908().field_9236) {
                this.method_8259(player);
                this.method_17449(player, this.method_5476(), this.wizardLevel);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        if (this.trades != null) {
            nbt.method_10566("trades", (class_2520)this.trades.method_8268());
        }
        nbt.method_10569("wizardXp", this.wizardXp);
        nbt.method_10569("wizardLevel", this.wizardLevel);
    }

    @Override
    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("trades")) {
            this.trades = new class_1916(nbt.method_10562("trades"));
        }
        this.wizardXp = nbt.method_10550("wizardXp");
        this.wizardLevel = nbt.method_10550("wizardLevel");
        if (this.wizardLevel == 0) {
            this.wizardLevel = 1;
        }
    }

    public void method_8262(class_1914 merchantOffer) {
        merchantOffer.method_8244();
        this.field_6191 = -this.method_5970();
        this.method_5783(EBSounds.ENTITY_WIZARD_YES.get(), this.method_6107(), this.method_6017());
        int xpGain = merchantOffer.method_19279();
        if (EBAccessoriesIntegration.isEquipped(this.customer, EBItems.CHARM_HAGGLER.get())) {
            xpGain *= 2;
        }
        this.wizardXp += xpGain;
        this.tryLevelUp();
        if (this.field_5974.method_43048(5) == 0 || EBAccessoriesIntegration.isEquipped(this.customer, EBItems.CHARM_HAGGLER.get())) {
            this.timeUntilReset = 40;
        }
        if (this.method_8257() == null) {
            return;
        }
        EBAdvancementTriggers.WIZARD_TRADE.triggerFor(this.method_8257());
        if (!(merchantOffer.method_8250().method_7909() instanceof SpellBookItem)) {
            return;
        }
        Spell spell = SpellUtil.getSpell(merchantOffer.method_8250());
        if (spell.getTier() == SpellTiers.MASTER) {
            EBAdvancementTriggers.BUY_MASTER_SPELL.triggerFor(this.method_8257());
        }
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(this.method_8257());
        if (WizardryEventBus.getInstance().fire(new EBDiscoverSpellEvent(this.method_8257(), spell, EBDiscoverSpellEvent.Source.PURCHASE))) {
            return;
        }
        if (!this.method_37908().field_9236) {
            data.discoverSpell(spell);
            if (!this.method_8257().method_7337()) {
                EntityUtil.playSoundAtPlayer(this.method_8257(), EBSounds.MISC_DISCOVER_SPELL.get(), 1.25f, 1.0f);
                this.method_8257().method_43496((class_2561)class_2561.method_43469((String)"spell.discover", (Object[])new Object[]{spell.getDescriptionFormatted()}));
            }
        }
    }

    private void tryLevelUp() {
        int nextLevel = class_3532.method_15340((int)(this.wizardLevel + 1), (int)1, (int)5);
        if (nextLevel > this.wizardLevel && this.wizardXp >= XP_PER_LEVEL[nextLevel - 1]) {
            this.wizardLevel = nextLevel;
            this.updateTrades();
            if (!this.method_37908().field_9236) {
                this.method_6092(new class_1293(class_1294.field_5924, 400, 1));
                this.method_37908().method_8421((class_1297)this, (byte)14);
            }
        }
    }

    @NotNull
    public class_1916 method_8264() {
        if (this.trades == null) {
            this.trades = new class_1916();
            this.updateTrades();
        }
        return this.trades;
    }

    private void updateTrades() {
        if (this.trades == null) {
            this.trades = new class_1916();
        }
        switch (this.wizardLevel) {
            case 1: {
                this.addNoviceTrades();
                break;
            }
            case 2: {
                this.addApprenticeTrades();
                break;
            }
            case 3: {
                this.addAdvancedTrades();
                break;
            }
            case 4: 
            case 5: {
                this.addMasterTrades();
            }
        }
    }

    private void addNoviceTrades() {
        ArrayList<class_1914> possibleTrades = new ArrayList<class_1914>();
        this.trades.add((Object)this.createTrade(new class_1799((class_1935)EBItems.SPELL_BOOK.get()), class_1799.field_8037, new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 4), 12, 2, 0.05f));
        if (this.getElement() != null && this.getElement() != Elements.MAGIC) {
            possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 3 + this.field_5974.method_43048(2)), new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get()), new class_1799((class_1935)RegistryUtils.getCrystal(this.getElement())), 12, 5, 0.05f));
        }
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 6 + this.field_5974.method_43048(5)), new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 4 + this.field_5974.method_43048(2)), new class_1799((class_1935)RegistryUtils.getWand(SpellTiers.NOVICE, this.getElement())), 3, 10, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.NOVICE, 1 + this.field_5974.method_43048(4), 2 + this.field_5974.method_43048(2)));
        possibleTrades.add(this.createSpellTrade(SpellTiers.NOVICE, 1 + this.field_5974.method_43048(4), 2 + this.field_5974.method_43048(2)));
        this.addRandomTrades(possibleTrades);
    }

    private void addApprenticeTrades() {
        ArrayList<class_1914> possibleTrades = new ArrayList<class_1914>();
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 13 + this.field_5974.method_43048(6)), new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 6 + this.field_5974.method_43048(5)), new class_1799((class_1935)RegistryUtils.getWand(SpellTiers.APPRENTICE, this.getElement())), 3, 20, 0.2f));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 14 + this.field_5974.method_43048(6)), new class_1799((class_1935)class_1802.field_8407, 4 + this.field_5974.method_43048(2)), new class_1799((class_1935)Wizard.getRandomUpgrade(this.field_5974)), 12, 10, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.APPRENTICE, 7 + this.field_5974.method_43048(4), 6 + this.field_5974.method_43048(5)));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 3 + this.field_5974.method_43048(2)), new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 3 + this.field_5974.method_43048(2)), new class_1799((class_1935)EBItems.MAGIC_SILK.get()), 12, 10, 0.2f));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 10 + this.field_5974.method_43048(3)), new class_1799((class_1935)class_1802.field_8529), SpellUtil.arcaneTomeItem(SpellTiers.APPRENTICE), 3, 30, 0.2f));
        this.addRandomTrades(possibleTrades);
    }

    private void addAdvancedTrades() {
        ArrayList<class_1914> possibleTrades = new ArrayList<class_1914>();
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 14 + this.field_5974.method_43048(6)), new class_1799((class_1935)class_1802.field_8407, 4 + this.field_5974.method_43048(2)), new class_1799((class_1935)Wizard.getRandomUpgrade(this.field_5974)), 12, 15, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.ADVANCED, 12 + this.field_5974.method_43048(5), 8 + this.field_5974.method_43048(8)));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 14 + this.field_5974.method_43048(3)), new class_1799((class_1935)class_1802.field_8529), SpellUtil.arcaneTomeItem(SpellTiers.ADVANCED), 3, 30, 0.2f));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 13 + this.field_5974.method_43048(4)), new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 8 + this.field_5974.method_43048(3)), new class_1799((class_1935)RegistryUtils.getArmor(WizardArmorType.WIZARD, this.getElement(), this.field_5974)), 3, 20, 0.2f));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 14 + this.field_5974.method_43048(6)), new class_1799((class_1935)EBItems.BLANK_SCROLL.get()), new class_1799((class_1935)EBItems.IDENTIFICATION_SCROLL.get()), 3, 30, 0.2f));
        this.addRandomTrades(possibleTrades);
    }

    private void addMasterTrades() {
        ArrayList<class_1914> possibleTrades = new ArrayList<class_1914>();
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 14 + this.field_5974.method_43048(6)), new class_1799((class_1935)class_1802.field_8407, 4 + this.field_5974.method_43048(2)), new class_1799((class_1935)Wizard.getRandomUpgrade(this.field_5974)), 12, 20, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.MASTER, 20 + this.field_5974.method_43048(6), 15 + this.field_5974.method_43048(6)));
        possibleTrades.add(this.createTrade(new class_1799((class_1935)class_1802.field_8695, 20 + this.field_5974.method_43048(6)), new class_1799((class_1935)EBItems.ASTRAL_DIAMOND.get()), SpellUtil.arcaneTomeItem(SpellTiers.MASTER), 3, 50, 0.2f));
        this.addRandomTrades(possibleTrades);
    }

    private class_1914 createSpellTrade(SpellTier tier, int goldAmount, int crystalAmount) {
        List<Spell> spells = SpellUtil.getSpells(s -> s.getTier() == tier);
        if (spells.isEmpty()) {
            return null;
        }
        Spell spell = spells.get(this.field_5974.method_43048(spells.size()));
        class_1799 spellBook = new class_1799((class_1935)EBItems.SPELL_BOOK.get());
        SpellUtil.setSpell(spellBook, spell);
        int xp = Wizard.getXpForTier(tier);
        return this.createTrade(new class_1799((class_1935)class_1802.field_8695, goldAmount), new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), crystalAmount), spellBook, 7, xp, 0.2f);
    }

    private void addRandomTrades(List<class_1914> possibleTrades) {
        Collections.shuffle(possibleTrades);
        int tradesToAdd = Math.min(2, possibleTrades.size());
        this.trades.addAll(possibleTrades.subList(0, tradesToAdd));
    }

    public static class_1792 getRandomUpgrade(class_5819 random) {
        int index = random.method_43048(WandUpgrades.getSpecialUpgrades().size());
        return (class_1792)WandUpgrades.getSpecialUpgrades().stream().toList().get(index);
    }

    private class_1914 createTrade(class_1799 cost1, class_1799 cost2, class_1799 result, int maxUses, int xp, float priceMultiplier) {
        return new class_1914(cost1, cost2, result, maxUses, xp, priceMultiplier);
    }

    protected class_3414 method_5994() {
        if (WizardryMainMod.IS_THE_SEASON) {
            return EBSounds.ENTITY_WIZARD_HOHOHO.get();
        }
        return this.isTrading() ? EBSounds.ENTITY_WIZARD_TRADING.get() : EBSounds.ENTITY_WIZARD_AMBIENT.get();
    }

    public boolean isTrading() {
        return this.method_8257() != null;
    }

    public class_1657 method_8257() {
        return this.customer;
    }

    public void method_8259(class_1657 player) {
        this.customer = player;
    }

    @NotNull
    public class_3414 method_18010() {
        return EBSounds.ENTITY_WIZARD_YES.get();
    }

    protected class_3414 method_6011(@NotNull class_1282 source) {
        return EBSounds.ENTITY_WIZARD_HURT.get();
    }

    protected class_3414 method_6002() {
        return EBSounds.ENTITY_WIZARD_DEATH.get();
    }

    public void method_8261(@NotNull class_1916 offers) {
        this.trades = offers;
    }

    public int method_19269() {
        return this.wizardXp;
    }

    public void method_19271(int xp) {
        this.wizardXp = xp;
    }

    public boolean method_19270() {
        return true;
    }

    public boolean method_20708() {
        return true;
    }

    public boolean method_38069() {
        return this.method_37908().method_8608();
    }
}

