/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import org.jetbrains.annotations.NotNull;

public class FlamecatcherArrow
extends MagicArrowEntity {
    public static final float SPEED = 3.0f;

    public FlamecatcherArrow(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FlamecatcherArrow(class_1937 world) {
        super(EBEntities.FLAME_CATCHER_ARROW.get(), world);
    }

    @Override
    public class_2960 getTexture() {
        return new class_2960("ebwizardry", "textures/entity/flamecatcher_arrow.png");
    }

    @Override
    public double getDamage() {
        return Spells.FLAMECATCHER.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return (int)(Spells.FLAMECATCHER.property(DefaultProperties.RANGE).floatValue() * 3.0f);
    }

    @Override
    public boolean doDeceleration() {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    @Override
    protected void method_7454(@NotNull class_3966 hitResult) {
        class_1297 class_12972 = hitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            if (!MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (class_1297)livingEntity)) {
                livingEntity.method_5639(15);
            }
            this.method_5783(EBSounds.ENTITY_FLAMECATCHER_ARROW_HIT.get(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            if (this.method_37908().field_9236) {
                ParticleBuilder.create(EBParticles.FLASH).pos(this.method_23317(), this.method_23318(), this.method_23321()).color(16739584).spawn(this.method_37908());
            }
        }
        super.method_7454(hitResult);
    }

    protected void method_24920(@NotNull class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (this.method_37908().field_9236) {
            class_243 vec = blockHitResult.method_17784().method_1019(new class_243((double)blockHitResult.method_17780().method_10148(), (double)blockHitResult.method_17780().method_10164(), (double)blockHitResult.method_17780().method_10165()).method_1021(0.15));
            ParticleBuilder.create(EBParticles.FLASH).pos(vec).color(16739584).fade(0.85f, 0.5f, 0.8f).spawn(this.method_37908());
        }
    }

    @NotNull
    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    @Override
    public void ticksInAir() {
        if (this.method_37908().field_9236) {
            ParticleBuilder.create(EBParticles.MAGIC_FIRE, this.method_37908().method_8409(), this.method_23317(), this.method_23318(), this.method_23321(), 0.03, false).time(20 + this.field_5974.method_43048(10)).spawn(this.method_37908());
            if (this.getLifetime() > 1) {
                double x = this.method_23317() - this.method_18798().field_1352 / 2.0;
                double y = this.method_23318() - this.method_18798().field_1351 / 2.0;
                double z = this.method_23321() - this.method_18798().field_1350 / 2.0;
                ParticleBuilder.create(EBParticles.MAGIC_FIRE, this.method_37908().method_8409(), x, y, z, 0.03, false).time(20 + this.field_5974.method_43048(10)).spawn(this.method_37908());
            }
        }
        super.ticksInAir();
    }

    @Override
    public class_5321<class_8110> getDamageType() {
        return EBDamageSources.FIRE;
    }
}

