/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import org.jetbrains.annotations.NotNull;

public class ForceArrow
extends MagicArrowEntity {
    private int mana = 0;

    public ForceArrow(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ForceArrow(class_1937 world) {
        super(EBEntities.FORCE_ARROW.get(), world);
    }

    @NotNull
    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Override
    protected void method_7454(@NotNull class_3966 hitResult) {
        this.method_5783(EBSounds.ENTITY_FORCE_ARROW_HIT.get(), 1.0f, 1.0f);
        if (this.method_37908().method_8608()) {
            ParticleBuilder.create(EBParticles.FLASH).pos(this.method_23317(), this.method_23318(), this.method_23321()).scale(1.3f).color(0.75f, 1.0f, 0.85f).spawn(this.method_37908());
        }
        super.method_7454(hitResult);
    }

    protected void method_24920(@NotNull class_3965 blockHitResult) {
        this.method_5783(EBSounds.ENTITY_FORCE_ARROW_HIT.get(), 1.0f, 1.0f);
        super.method_24920(blockHitResult);
        if (this.method_37908().method_8608()) {
            class_243 pos = blockHitResult.method_17784().method_1019(class_243.method_24954((class_2382)blockHitResult.method_17780().method_10163()).method_1021(0.15));
            ParticleBuilder.create(EBParticles.FLASH).pos(pos).scale(1.6f).color(0.75f, 1.0f, 0.85f).spawn(this.method_37908());
        }
    }

    @Override
    public void method_5773() {
        if (this.getLifetime() >= 0 && this.field_6012 > this.getLifetime()) {
            this.returnManaToCaster();
        }
        super.method_5773();
    }

    private void returnManaToCaster() {
        class_1297 class_12972;
        if (this.mana <= 0 || !((class_12972 = this.method_24921()) instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        if (!player.method_7337() && EBAccessoriesIntegration.isEquipped(player, EBItems.RING_MANA_RETURN.get())) {
            InventoryUtil.getHotBarAndOffhand(player).stream().filter(st -> st.method_7909() instanceof IManaStoringItem).findAny().ifPresent(st -> ((IManaStoringItem)st.method_7909()).rechargeMana((class_1799)st, this.mana));
        }
    }

    @Override
    @NotNull
    protected class_3414 method_7440() {
        return EBSounds.ENTITY_FORCE_ARROW_HIT.get();
    }

    @Override
    public void tickInGround() {
        this.returnManaToCaster();
        this.method_31472();
    }

    @Override
    public double getDamage() {
        return Spells.FORCE_ARROW.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return 20;
    }

    public boolean method_5740() {
        return true;
    }

    @Override
    public class_2960 getTexture() {
        return new class_2960("ebwizardry", "textures/entity/force_arrow.png");
    }

    @Override
    public class_5321<class_8110> getDamageType() {
        return EBDamageSources.FORCE;
    }
}

