/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.entity.projectile.IceShardEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class IceChargeEntity
extends BombEntity {
    public static final SpellProperty<Integer> ICE_SHARDS = SpellProperty.intProperty("ice_shards");

    public IceChargeEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public IceChargeEntity(class_1937 world) {
        super(EBEntities.ICE_CHARGE.get(), world);
    }

    protected void method_7488(@NotNull class_239 hitResult) {
        class_1297 entity;
        super.method_7488(hitResult);
        class_1297 class_12972 = entity = hitResult.method_17783() == class_239.class_240.field_1331 ? ((class_3966)hitResult).method_17782() : null;
        if (entity != null) {
            float damage = Spells.ICE_CHARGE.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            MagicDamageSource.causeMagicDamage((class_1297)this, entity, damage, EBDamageSources.FROST);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!this.method_37908().field_9236) {
                    livingEntity.method_6092(new class_1293(EBMobEffects.FROST.get(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
                }
            }
        }
        if (this.method_37908().method_8608()) {
            this.spawnParticles();
            return;
        }
        this.method_5783(EBSounds.ENTITY_ICE_CHARGE_SMASH.get(), 1.5f, this.field_5974.method_43057() * 0.4f + 0.6f);
        this.method_5783(EBSounds.ENTITY_ICE_CHARGE_ICE.get(), 1.2f, this.field_5974.method_43057() * 0.4f + 1.2f);
        double radius = 3.0f * this.blastMultiplier;
        List<class_1309> targets = EntityUtil.getLivingEntitiesInRange(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), radius);
        for (class_1309 target : targets) {
            if (target == entity || target == this.method_24921() || this.method_37908().field_9236) continue;
            target.method_6092(new class_1293(EBMobEffects.FROST.get(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        }
        this.freezeNearbyBlocks();
        for (int i = 0; i < Spells.ICE_CHARGE.property(ICE_SHARDS); ++i) {
            double dx = this.field_5974.method_43058() - 0.5;
            double dy = this.field_5974.method_43058() - 0.5;
            double dz = this.field_5974.method_43058() - 0.5;
            IceShardEntity iceShard = new IceShardEntity(this.method_37908());
            iceShard.method_5814(this.method_23317() + dx, this.method_23318() + dy, this.method_23321() + dz);
            iceShard.method_18800(dx * 1.5, dy * 1.5, dz * 1.5);
            this.method_37908().method_8649((class_1297)iceShard);
        }
        this.method_31472();
    }

    private void freezeNearbyBlocks() {
        class_1937 level = this.method_37908();
        class_2338 basePos = class_2338.method_49638((class_2374)this.method_19538());
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                double dist;
                class_2338 pos = basePos.method_10069(i, 0, j);
                Integer y = BlockUtil.getNearestSurface(level, pos, class_2350.field_11036, 7, true, BlockUtil.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                if (y == null || this.field_5974.method_43048((int)(dist = this.method_5649((pos = new class_2338(pos.method_10263(), y.intValue(), pos.method_10260())).method_10263(), pos.method_10264(), pos.method_10260())) * 2 + 1) >= 1 || !(dist < 2.0)) continue;
                class_2680 belowState = level.method_8320(pos.method_10074());
                level.method_8652(pos, belowState.method_26204() == class_2246.field_10382 ? class_2246.field_10295.method_9564() : class_2246.field_10477.method_9564(), 3);
            }
        }
    }

    private void spawnParticles() {
        class_1937 level = this.method_37908();
        level.method_8406((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        int i = 0;
        while ((float)i < 30.0f * this.blastMultiplier) {
            ParticleBuilder.create(EBParticles.ICE, level.method_8409(), this.method_23317(), this.method_23318(), this.method_23321(), 2.0f * this.blastMultiplier, false).time(35).gravity(true).spawn(level);
            float brightness = 0.4f + level.method_8409().method_43057() * 0.5f;
            ParticleBuilder.create(EBParticles.DARK_MAGIC, level.method_8409(), this.method_23317(), this.method_23318(), this.method_23321(), 2.0f * this.blastMultiplier, false).color(brightness, brightness + 0.1f, 1.0f).spawn(level);
            ++i;
        }
    }

    @NotNull
    protected class_1792 method_16942() {
        return class_1799.field_8037.method_7909();
    }
}

