/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3532;

public class BlankScrollItem
extends class_1792
implements IWorkbenchItem {
    public BlankScrollItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public boolean onApplyButtonPressed(class_1657 player, class_1735 centre, class_1735 crystals, class_1735 upgrade, class_1735[] spellBooks) {
        if (spellBooks[0].method_7677().method_7960() || crystals.method_7677().method_7960()) {
            return false;
        }
        Spell spell = SpellUtil.getSpell(spellBooks[0].method_7677());
        if (!this.canPlayerUseSpell(player, spell)) {
            return false;
        }
        int scrollCost = this.calculateScrollCost(spell, centre.method_7677().method_7947());
        int manaPerCrystal = this.getManaPerCrystal(crystals.method_7677());
        if (this.hasEnoughMana(crystals.method_7677().method_7947(), manaPerCrystal, scrollCost)) {
            this.consumeCrystalsAndCreateScroll(crystals, centre, spell, scrollCost, manaPerCrystal);
            return true;
        }
        return false;
    }

    private boolean canPlayerUseSpell(class_1657 player, Spell spell) {
        if (spell == Spells.NONE) {
            return false;
        }
        if (!spell.isEnabled(SpellContext.SCROLL)) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        return data != null && data.hasSpellBeenDiscovered(spell);
    }

    private int calculateScrollCost(Spell spell, int scrollCount) {
        int cost = spell.getProperties().getCost() * scrollCount;
        if (!spell.isInstantCast()) {
            cost *= 6;
        }
        return cost;
    }

    private int getManaPerCrystal(class_1799 crystalStack) {
        class_1792 crystal = crystalStack.method_7909();
        if (crystal == EBItems.MAGIC_CRYSTAL_SHARD.get()) {
            return 10;
        }
        if (crystal == EBItems.MAGIC_CRYSTAL_GRAND.get()) {
            return 400;
        }
        return 100;
    }

    private boolean hasEnoughMana(int crystalCount, int manaPerCrystal, int requiredMana) {
        return crystalCount * manaPerCrystal > requiredMana;
    }

    private void consumeCrystalsAndCreateScroll(class_1735 crystals, class_1735 centre, Spell spell, int cost, int manaPerCrystal) {
        crystals.method_7671(class_3532.method_15386((float)((float)cost / (float)manaPerCrystal)));
        class_1799 scroll = SpellUtil.setSpell(EBItems.SCROLL.get().method_7854(), spell);
        scroll.method_7939(centre.method_7677().method_7947());
        centre.method_7673(scroll);
    }

    @Override
    public int getSpellSlotCount(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean showTooltip(class_1799 stack) {
        return false;
    }
}

