/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.CastUtils;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.SpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollItem
extends class_1792
implements ISpellCastingItem,
IWorkbenchItem {
    public static final int CASTING_TIME = 120;
    public static final int COOLDOWN_FORFEIT_TICKS = 60;

    public ScrollItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Spell spell = this.getCurrentSpell(stack);
        if (spell == Spells.NONE) {
            return class_1271.method_22431((Object)stack);
        }
        PlayerCastContext ctx = new PlayerCastContext(level, player, hand, 0, new SpellModifiers());
        if (!this.canCast(stack, spell, ctx)) {
            return class_1271.method_22431((Object)stack);
        }
        if (!spell.isInstantCast()) {
            player.method_6019(hand);
            Services.OBJECT_DATA.getWizardData(player).setSpellModifiers(ctx.modifiers());
            return class_1271.method_22428((Object)stack);
        }
        if (this.cast(stack, spell, ctx)) {
            if (!level.field_9236 && spell.requiresPacket()) {
                Services.NETWORK_HELPER.sendToDimension(level.method_8503(), new SpellCastS2C(player.method_5628(), hand, spell, ctx.modifiers()), (class_5321<class_1937>)level.method_27983());
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 livingEntity, @NotNull class_1799 stack, int timeLeft) {
        if (!(livingEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        Spell spell = SpellUtil.getSpell(stack);
        int castingTick = stack.method_7935() - timeLeft;
        PlayerCastContext ctx = new PlayerCastContext(level, player, player.method_6058(), castingTick, Services.OBJECT_DATA.getWizardData(player).getSpellModifiers());
        if (!spell.isInstantCast() && this.canCast(stack, spell, ctx)) {
            spell.cast(ctx);
        } else {
            livingEntity.method_6021();
        }
    }

    @Override
    public boolean canCast(class_1799 stack, Spell spell, PlayerCastContext ctx) {
        if (CastUtils.fireSpellCastEvent(SpellCastEvent.Source.SCROLL, spell, ctx)) {
            CastUtils.applyCooldownForfeit(ctx.caster(), 60);
            return false;
        }
        return true;
    }

    @Override
    public boolean cast(class_1799 stack, Spell spell, PlayerCastContext ctx) {
        if (!CastUtils.executeSpellCast(SpellCastEvent.Source.SCROLL, spell, ctx)) {
            return false;
        }
        if (spell.isInstantCast() && !ctx.caster().method_7337()) {
            stack.method_7934(1);
            ctx.caster().method_7357().method_7906((class_1792)this, spell.getCooldown());
        }
        CastUtils.trackSpellUsage(ctx.caster(), spell);
        return true;
    }

    private void finishCast(class_1799 stack, class_1937 world, class_1309 entity, int timeCharged) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        Spell spell = SpellUtil.getSpell(stack);
        if (spell.isInstantCast()) {
            return;
        }
        if (!player.method_7337()) {
            stack.method_7934(1);
            player.method_7357().method_7906((class_1792)this, spell.getCooldown());
        }
        int castingTick = stack.method_7935() - timeCharged;
        SpellModifiers modifiers = new SpellModifiers();
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Finish(SpellCastEvent.Source.SCROLL, spell, entity, modifiers, castingTick));
        spell.endCast(new CastContext(world, entity, castingTick, modifiers));
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> list, @NotNull class_1836 tooltipFlag) {
        if (level == null) {
            return;
        }
        Spell spell = SpellUtil.getSpell(stack);
        if (ClientUtils.shouldDisplayDiscovered(spell, stack) && tooltipFlag.method_8035()) {
            list.add((class_2561)class_2561.method_43471((String)spell.getTier().getDescriptionId()).method_27692(class_124.field_1080));
            list.add((class_2561)class_2561.method_43471((String)spell.getElement().getDescriptionId()).method_27692(class_124.field_1080));
            list.add((class_2561)class_2561.method_43471((String)spell.getType().getUnlocalisedName()).method_27692(class_124.field_1080));
        }
    }

    @NotNull
    public class_1799 method_7861(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 livingEntity) {
        this.finishCast(stack, level, livingEntity, 0);
        return super.method_7861(stack, level, livingEntity);
    }

    public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 livingEntity, int timeCharged) {
        this.finishCast(stack, level, livingEntity, timeCharged);
    }

    @Override
    @NotNull
    public Spell getCurrentSpell(class_1799 stack) {
        return SpellUtil.getSpell(stack);
    }

    @Override
    public boolean showSpellHUD(class_1657 player, class_1799 stack) {
        return false;
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        return true;
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        return ClientUtils.getScrollDisplayName(stack);
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 120;
    }

    @Override
    public boolean showTooltip(class_1799 stack) {
        return false;
    }

    @Override
    public boolean onApplyButtonPressed(class_1657 player, class_1735 centre, class_1735 crystals, class_1735 upgrade, class_1735[] spellBooks) {
        return false;
    }

    @Override
    public int getSpellSlotCount(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean canPlace(class_1799 stack) {
        return false;
    }
}

