/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.item.ITierValue;
import com.binaris.wizardry.api.content.item.IWizardryItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.CastUtils;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.api.content.util.WorkbenchUtils;
import com.binaris.wizardry.content.item.ArcaneTomeItem;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WandItem
extends class_1792
implements ISpellCastingItem,
IManaStoringItem,
IWorkbenchItem,
IWizardryItem,
ITierValue,
IElementValue {
    public static final int BASE_SPELL_SLOTS = 5;
    public static final int COOLDOWN_FORFEIT_TICKS = 60;
    public static final int MAX_USE_DURATION = 72000;
    private final SpellTier tier;
    private final Element element;

    public WandItem(SpellTier tier, Element element) {
        super(new class_1792.class_1793().method_7889(1).method_7895(tier.maxCharge));
        this.tier = tier;
        this.element = element;
    }

    protected static int getAccumulatedCost(Spell spell, int castingTick, int totalCost) {
        int accumulatedCost = 0;
        if (!spell.isInstantCast() && castingTick > 0) {
            int completeCycles = castingTick / 20;
            int remainingTicks = castingTick % 20;
            accumulatedCost = completeCycles * totalCost;
            if (remainingTicks > 0) {
                accumulatedCost += totalCost / 2 + totalCost % 2;
                if (remainingTicks >= 10) {
                    accumulatedCost += totalCost / 2;
                }
            }
        }
        return accumulatedCost;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Spell spell = WandHelper.getCurrentSpell(stack);
        if (spell == Spells.NONE) {
            return class_1271.method_22430((Object)stack);
        }
        PlayerCastContext ctx = this.createContext(level, player, hand, 0, stack, spell);
        if (!this.canCastRequirements(stack, spell, ctx)) {
            return class_1271.method_22431((Object)stack);
        }
        int charge = this.calculateCharge(spell, ctx);
        if (!this.requiresCharging(spell, charge)) {
            if (this.canCast(stack, spell, ctx)) {
                if (!level.field_9236) {
                    this.consumeManaAndSetCooldown(stack, spell, player, ctx.modifiers());
                }
                if (this.cast(stack, spell, ctx)) {
                    return class_1271.method_22427((Object)stack);
                }
            }
            return class_1271.method_22431((Object)stack);
        }
        return this.startCharging(level, player, hand, stack, charge, ctx);
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 user, @NotNull class_1799 stack, int timeLeft) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        Spell spell = WandHelper.getCurrentSpell(stack);
        SpellModifiers modifiers = Services.OBJECT_DATA.getWizardData(player).getSpellModifiers();
        int useTick = stack.method_7935() - timeLeft;
        int charge = this.calculateCharge(spell, modifiers);
        int castingTick = spell.isInstantCast() ? (useTick == charge ? 0 : -1) : Math.max(0, useTick - charge);
        PlayerCastContext ctx = this.createContext(level, player, user.method_6058(), castingTick, stack, spell);
        if (spell.isInstantCast()) {
            this.handleInstantSpellTick(ctx, spell, stack, useTick, charge);
        } else {
            this.handleContinuousSpellTick(ctx, spell, stack, useTick, charge);
        }
    }

    @Override
    public boolean canCast(class_1799 stack, Spell spell, PlayerCastContext ctx) {
        if (CastUtils.fireSpellCastEvent(SpellCastEvent.Source.WAND, spell, ctx)) {
            CastUtils.applyCooldownForfeit(ctx.caster(), 60);
            return false;
        }
        return this.canCastRequirements(stack, spell, ctx);
    }

    private boolean canCastRequirements(class_1799 stack, Spell spell, PlayerCastContext ctx) {
        int cost = (int)((float)spell.getCost() * ctx.modifiers().get("cost") + 0.1f);
        if (!spell.isInstantCast()) {
            cost = WandHelper.getDistributedCost(cost, ctx.castingTicks());
        }
        return cost <= this.getMana(stack) && spell.getTier().level <= this.tier.level && (WandHelper.getCurrentCooldown(stack, ctx.world().method_8510()) == 0 || ctx.caster().method_7337());
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        if (this.tier == SpellTiers.MASTER) {
            return false;
        }
        return WandHelper.getProgression(stack) >= this.tier.getProgression();
    }

    @Override
    public boolean cast(class_1799 stack, Spell spell, PlayerCastContext ctx) {
        if (ctx.world().field_9236 && spell.isInstantCast() && spell.requiresPacket()) {
            return false;
        }
        if (!CastUtils.executeSpellCast(SpellCastEvent.Source.WAND, spell, ctx)) {
            return false;
        }
        CastUtils.sendSpellCastPacket(ctx.caster(), spell, ctx);
        if (!spell.isInstantCast()) {
            ctx.caster().method_6019(ctx.hand());
        }
        this.handleProgression(ctx, spell, stack);
        CastUtils.trackSpellUsage(ctx.caster(), spell);
        return true;
    }

    @NotNull
    public class_1269 method_7847(@NotNull class_1799 stack, class_1657 player, @NotNull class_1309 interactionTarget, @NotNull class_1268 usedHand) {
        if (player.method_18276() && interactionTarget instanceof class_1657) {
            String string;
            class_1657 playerTarget = (class_1657)interactionTarget;
            WizardData data = Services.OBJECT_DATA.getWizardData(player);
            String string2 = string = data.toggleAlly(playerTarget) ? "item.ebwizardry.wand.add_ally" : "item.ebwizardry.wand.remove_ally";
            if (!player.method_37908().field_9236) {
                player.method_43496((class_2561)class_2561.method_43469((String)string, (Object[])new Object[]{playerTarget.method_5477()}));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 livingEntity, int timeCharged) {
        if (!(livingEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        Spell spell = WandHelper.getCurrentSpell(stack);
        WizardData wizardData = Services.OBJECT_DATA.getWizardData(player);
        SpellModifiers modifiers = wizardData.getSpellModifiers();
        int castingTick = stack.method_7935() - timeCharged;
        int totalCost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
        int accumulatedCost = WandItem.getAccumulatedCost(spell, castingTick, totalCost);
        if (!spell.isInstantCast() && spell.getTier().level <= this.tier.level) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Finish(SpellCastEvent.Source.WAND, spell, livingEntity, modifiers, castingTick));
            spell.endCast(new CastContext(player.method_37908(), (class_1309)player, castingTick, modifiers));
            if (!level.field_9236) {
                this.consumeMana(stack, accumulatedCost, (class_1309)player);
                if (!player.method_7337()) {
                    WandHelper.setCurrentCooldown(stack, (int)((float)spell.getCooldown() * modifiers.get(EBItems.COOLDOWN_UPGRADE.get())), level.method_8510());
                }
            }
        }
    }

    @Override
    public boolean onApplyButtonPressed(class_1657 player, class_1735 centre, class_1735 crystals, class_1735 upgrade, class_1735[] spellBooks) {
        boolean changed = false;
        if (upgrade.method_7681()) {
            changed = this.applyUpgradeSlot(player, centre, upgrade);
        }
        changed |= WorkbenchUtils.applySpellBooks(centre, spellBooks, SpellContext.WANDS);
        return changed |= WorkbenchUtils.rechargeManaFromCrystals(centre, crystals);
    }

    @Override
    public class_1799 applyUpgrade(@Nullable class_1657 player, class_1799 wand, class_1799 upgrade) {
        if (upgrade.method_7909() == EBItems.ARCANE_TOME.get()) {
            return this.applyTierUpgrade(player, wand, upgrade);
        }
        if (WandUpgrades.isWandUpgrade(upgrade.method_7909())) {
            this.applySpecialUpgrade(player, wand, upgrade);
        }
        return wand;
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1297 entity, int slot, boolean isHeldInMainhand) {
        if (!world.field_9236 && !this.isManaFull(stack) && world.method_8510() % 50L == 0L) {
            this.rechargeMana(stack, WandHelper.getUpgradeLevel(stack, EBItems.CONDENSER_UPGRADE.get()));
        }
    }

    @Override
    public void onClearButtonPressed(class_1657 player, class_1735 centre, class_1735 crystals, class_1735 upgrade, class_1735[] spellBooks) {
        class_1799 stack = centre.method_7677();
        if (!stack.method_7948().method_10545("spells")) {
            return;
        }
        List<Spell> spells = WandHelper.getSpells(stack);
        int expectedSlotCount = 5 + WandHelper.getUpgradeLevel(stack, EBItems.ATTUNEMENT_UPGRADE.get());
        if (spells.size() < expectedSlotCount) {
            spells = new ArrayList<Spell>();
        }
        WandHelper.setSpells(stack, spells);
    }

    protected void handleInstantSpellTick(PlayerCastContext ctx, Spell spell, class_1799 stack, int useTick, int charge) {
        if (useTick != charge) {
            return;
        }
        if (this.canCast(stack, spell, ctx)) {
            if (!ctx.world().field_9236) {
                this.consumeManaAndSetCooldown(stack, spell, ctx.caster(), ctx.modifiers());
            }
            this.cast(stack, spell, ctx);
        }
        ctx.caster().method_6021();
    }

    private void handleContinuousSpellTick(PlayerCastContext ctx, Spell spell, class_1799 stack, int useTick, int charge) {
        if (useTick < charge) {
            return;
        }
        if (this.canCast(stack, spell, ctx)) {
            this.cast(stack, spell, ctx);
        } else {
            ctx.caster().method_6021();
        }
    }

    private class_1271<class_1799> startCharging(class_1937 level, class_1657 player, class_1268 hand, class_1799 stack, int charge, PlayerCastContext ctx) {
        if (!player.method_6115()) {
            player.method_6019(hand);
            Services.OBJECT_DATA.getWizardData(player).setSpellModifiers(ctx.modifiers());
            if (charge > 0 && level.field_9236) {
                ClientSpellSoundManager.playChargeSound((class_1309)player);
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    protected PlayerCastContext createContext(class_1937 level, class_1657 player, class_1268 hand, int tick, class_1799 stack, Spell spell) {
        SpellModifiers modifiers = tick == 0 ? WandHelper.calculateModifiers(stack, player, spell) : Services.OBJECT_DATA.getWizardData(player).getSpellModifiers();
        return new PlayerCastContext(level, player, hand, tick, modifiers);
    }

    protected int calculateCharge(Spell spell, PlayerCastContext ctx) {
        return this.calculateCharge(spell, ctx.modifiers());
    }

    private int calculateCharge(Spell spell, SpellModifiers modifiers) {
        return (int)((float)spell.getCharge() * modifiers.get("chargeup"));
    }

    private void consumeManaAndSetCooldown(class_1799 stack, Spell spell, class_1657 player, SpellModifiers modifiers) {
        int cost = this.calculateSpellCost(spell, modifiers);
        this.consumeMana(stack, cost, (class_1309)player);
        if (!player.method_7337()) {
            WandHelper.setCurrentCooldown(stack, (int)((float)spell.getCooldown() * modifiers.get(EBItems.COOLDOWN_UPGRADE.get())), player.method_37908().method_8510());
        }
    }

    private int calculateSpellCost(Spell spell, SpellModifiers modifiers) {
        return (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
    }

    private boolean requiresCharging(Spell spell, int charge) {
        return !spell.isInstantCast() || charge > 0;
    }

    protected boolean applyUpgradeSlot(class_1657 player, class_1735 centre, class_1735 upgrade) {
        class_1799 original = centre.method_7677().method_7972();
        centre.method_7673(this.applyUpgrade(player, centre.method_7677(), upgrade.method_7677()));
        return !class_1799.method_7984((class_1799)centre.method_7677(), (class_1799)original);
    }

    protected class_1799 applyTierUpgrade(@Nullable class_1657 player, class_1799 wand, class_1799 tomeStack) {
        if (this.tier == SpellTiers.MASTER) {
            return wand;
        }
        class_1792 class_17922 = tomeStack.method_7909();
        if (!(class_17922 instanceof ArcaneTomeItem)) {
            return wand;
        }
        ArcaneTomeItem tomeItem = (ArcaneTomeItem)class_17922;
        SpellTier nextTier = tomeItem.getTier(tomeStack);
        if (this.tier == nextTier) {
            return wand;
        }
        if (player == null || WandHelper.getProgression(wand) >= nextTier.getProgression()) {
            int newProgression = Math.max(0, WandHelper.getProgression(wand) - nextTier.getProgression());
            WandHelper.setProgression(wand, newProgression);
            if (player != null) {
                Services.OBJECT_DATA.getWizardData(player).setTierReached(this.tier);
            }
            class_1799 newWand = new class_1799((class_1935)RegistryUtils.getWand(nextTier, this.element));
            newWand.method_7980(wand.method_7969());
            ((IManaStoringItem)newWand.method_7909()).setMana(newWand, this.getMana(wand));
            tomeStack.method_7934(1);
            return newWand;
        }
        return wand;
    }

    protected void applySpecialUpgrade(@Nullable class_1657 player, class_1799 wand, class_1799 upgrade) {
        class_1792 specialUpgrade = upgrade.method_7909();
        int maxUpgrades = this.tier.upgradeLimit + (this.element == Elements.MAGIC ? 3 : 0);
        if (WandHelper.getTotalUpgrades(wand) >= maxUpgrades || WandHelper.getUpgradeLevel(wand, specialUpgrade) >= 3) {
            return;
        }
        int prevMana = this.getMana(wand);
        WandHelper.applyUpgrade(wand, specialUpgrade);
        if (specialUpgrade == EBItems.STORAGE_UPGRADE.get()) {
            this.setMana(wand, prevMana);
        } else if (specialUpgrade == EBItems.ATTUNEMENT_UPGRADE.get()) {
            this.expandSpellSlots(wand);
        }
        upgrade.method_7934(1);
        if (player == null) {
            return;
        }
        EBAdvancementTriggers.SPECIAL_UPGRADE.triggerFor(player);
        if (WandHelper.getTotalUpgrades(wand) == SpellTiers.MASTER.upgradeLimit) {
            EBAdvancementTriggers.MAX_OUT_WAND.triggerFor(player);
        }
    }

    protected void expandSpellSlots(class_1799 wand) {
        int newSlotCount = 5 + WandHelper.getUpgradeLevel(wand, EBItems.ATTUNEMENT_UPGRADE.get());
        List<Spell> spells = WandHelper.getSpells(wand);
        Spell[] newSpells = new Spell[newSlotCount];
        for (int i = 0; i < newSpells.length; ++i) {
            newSpells[i] = i < spells.size() && spells.get(i) != null ? spells.get(i) : Spells.NONE;
        }
        WandHelper.setSpells(wand, List.of(newSpells));
    }

    protected void handleProgression(PlayerCastContext ctx, Spell spell, class_1799 stack) {
        boolean shouldAddProgression;
        if (this.tier.level >= SpellTiers.MASTER.level) {
            return;
        }
        boolean bl = spell.isInstantCast() ? ctx.castingTicks() == 0 : (shouldAddProgression = ctx.castingTicks() % 20 == 0);
        if (!shouldAddProgression) {
            return;
        }
        int progression = (int)((float)spell.getCost() * ctx.modifiers().get("progression"));
        WandHelper.addProgression(stack, progression);
        this.checkLevelUp(ctx, stack, progression);
    }

    protected void checkLevelUp(PlayerCastContext ctx, class_1799 stack, int progression) {
        class_1657 player = ctx.caster();
        SpellTier nextTier = this.tier.next();
        int excess = WandHelper.getProgression(stack) - nextTier.getProgression();
        if (excess >= 0 && excess < progression) {
            player.method_5783(EBSounds.ITEM_WAND_LEVELUP.get(), 1.25f, 1.0f);
            if (!player.method_37908().field_9236) {
                player.method_43496((class_2561)class_2561.method_43469((String)"item.ebwizardry.wand.levelup", (Object[])new Object[]{this.method_7864(stack), nextTier.getDescriptionFormatted()}));
            }
        }
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        return this.element == null ? super.method_7864(stack) : class_2561.method_43470((String)super.method_7864(stack).getString()).method_27692(this.element.getColor());
    }

    @Override
    public void selectNextSpell(class_1799 stack) {
        Spell nextSpell = WandHelper.getNextSpell(stack);
        WandHelper.setCurrentSpell(stack, nextSpell);
    }

    @Override
    public void selectPreviousSpell(class_1799 stack) {
        Spell previousSpell = WandHelper.getPreviousSpell(stack);
        WandHelper.setCurrentSpell(stack, previousSpell);
    }

    @Override
    public int getMaxDamage(class_1799 stack) {
        return (int)((float)this.method_7841() * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel(stack, EBItems.STORAGE_UPGRADE.get())) + 0.5f);
    }

    @Override
    public void setDamage(class_1799 stack, int damage) {
        stack.method_7948().method_10569("Damage", Math.max(0, Math.min(damage, stack.method_7936())));
    }

    public int method_31571(class_1799 stack) {
        return DrawingUtils.mix(16747518, 9318116, stack.method_7919());
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 72000;
    }

    @Override
    public boolean isClearable() {
        return true;
    }

    @Override
    public boolean showTooltip(class_1799 stack) {
        return true;
    }

    @Override
    public boolean selectSpell(class_1799 stack, int index) {
        return WandHelper.selectSpell(stack, index);
    }

    @Override
    public int getCurrentCooldown(class_1799 stack, class_1937 level) {
        return WandHelper.getCurrentCooldown(stack, level.method_8510());
    }

    @Override
    public int getCurrentMaxCooldown(class_1799 stack) {
        return WandHelper.getCurrentMaxCooldown(stack);
    }

    @Override
    public boolean showSpellHUD(class_1657 player, class_1799 stack) {
        return true;
    }

    @Override
    public int getMana(class_1799 stack) {
        return this.getManaCapacity(stack) - stack.method_7919();
    }

    @Override
    public int getManaCapacity(class_1799 stack) {
        return stack.method_7936();
    }

    @Override
    public void setMana(class_1799 stack, int mana) {
        stack.method_7974(this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getSpellSlotCount(class_1799 stack) {
        return 5 + WandHelper.getUpgradeLevel(stack, EBItems.ATTUNEMENT_UPGRADE.get());
    }

    @Override
    @NotNull
    public Spell getCurrentSpell(class_1799 stack) {
        return WandHelper.getCurrentSpell(stack);
    }

    @Override
    @NotNull
    public Spell getNextSpell(class_1799 stack) {
        return WandHelper.getNextSpell(stack);
    }

    @Override
    @NotNull
    public Spell getPreviousSpell(class_1799 stack) {
        return WandHelper.getPreviousSpell(stack);
    }

    @Override
    public Spell[] getSpells(class_1799 stack) {
        return WandHelper.getSpells(stack).toArray(new Spell[0]);
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean validForReceptacle() {
        return false;
    }

    @Override
    public SpellTier getTier(class_1799 stack) {
        return this.tier;
    }
}

