/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.WorkbenchUtils;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardArmorItem
extends class_1738
implements IManaStoringItem,
IWorkbenchItem,
IElementValue {
    private static final float SAGE_OTHER_COST_REDUCTION = 0.2f;
    private static final float WARLOCK_SPEED_BOOST = 0.2f;
    private final Element element;
    private final WizardArmorType wizardArmorType;

    public WizardArmorItem(WizardArmorType material, class_1738.class_8051 type, Element element) {
        super((class_1741)material, type, new class_1792.class_1793());
        this.wizardArmorType = material;
        this.element = element;
    }

    public static void onSpellPreCast(SpellCastEvent.Pre event) {
        class_1309 class_13092;
        if (event.getCaster() == null || !((class_13092 = event.getCaster()) instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        SpellModifiers armourModifiers = new SpellModifiers();
        WizardArmorItem.collectArmorModifiers(player, event.getSpell(), armourModifiers);
        event.getModifiers().combine(armourModifiers);
    }

    public static void onSpellTickCast(SpellCastEvent.Tick event) {
        class_1309 class_13092;
        if (event.getCaster() == null || !((class_13092 = event.getCaster()) instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        SpellModifiers armourModifiers = new SpellModifiers();
        WizardArmorItem.collectArmorModifiers(player, event.getSpell(), armourModifiers);
        event.getModifiers().combine(armourModifiers);
    }

    private static void collectArmorModifiers(class_1657 caster, Spell spell, SpellModifiers out) {
        Arrays.stream(InventoryUtil.ARMOR_SLOTS).map(slot -> caster.method_6118(slot).method_7909()).filter(i -> i instanceof WizardArmorItem).forEach(i -> ((WizardArmorItem)i).applySpellModifiers((class_1309)caster, spell, out));
    }

    @Override
    public class_1799 applyUpgrade(@Nullable class_1657 player, class_1799 stack, class_1799 upgrade) {
        if (this.wizardArmorType != WizardArmorType.WIZARD) {
            return stack;
        }
        for (WizardArmorType armourClass : WizardArmorType.values()) {
            if (upgrade.method_7909() != armourClass.upgradeItem.get()) continue;
            class_1792 newItem = RegistryUtils.getArmor(armourClass, this.element, this.method_7685());
            class_1799 newStack = new class_1799((class_1935)newItem);
            ((WizardArmorItem)newItem).setMana(newStack, this.getMana(stack));
            newStack.method_7980(stack.method_7969());
            upgrade.method_7934(1);
            return newStack;
        }
        return stack;
    }

    @Override
    public boolean onApplyButtonPressed(class_1657 player, class_1735 centre, class_1735 crystals, class_1735 upgrade, class_1735[] spellBooks) {
        boolean changed = false;
        if (upgrade.method_7681()) {
            class_1799 original = centre.method_7677().method_7972();
            centre.method_7673(this.applyUpgrade(player, centre.method_7677(), upgrade.method_7677()));
            changed = !class_1799.method_7984((class_1799)centre.method_7677(), (class_1799)original);
        }
        return changed |= WorkbenchUtils.rechargeManaFromCrystals(centre, crystals);
    }

    public void method_7851(@NotNull class_1799 stack, class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 advanced) {
        if (this.getElement() != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.%s.wizard_armor.element_cost_reduction".formatted("ebwizardry"), (Object[])new Object[]{(int)(this.wizardArmorType.elementalCostReduction * 100.0f), this.element.getDescriptionFormatted().getString()}).method_27692(class_124.field_1063));
        }
        if (this.wizardArmorType == WizardArmorType.SAGE) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.%s.wizard_armor.enchantability".formatted("ebwizardry")).method_27692(class_124.field_1078));
        }
        if (this.wizardArmorType.cooldownReduction > 0.0f) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.%s.wizard_armor.cooldown_reduction".formatted("ebwizardry"), (Object[])new Object[]{(int)(this.wizardArmorType.cooldownReduction * 100.0f)}).method_27692(class_124.field_1063));
        }
        if (this.wizardArmorType != WizardArmorType.WIZARD) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.%s.wizard_armor.full_set".formatted("ebwizardry")).method_27692(class_124.field_1075));
            Object[] args = new Object[]{};
            if (this.wizardArmorType == WizardArmorType.SAGE) {
                args = new Object[]{20};
            }
            if (this.wizardArmorType == WizardArmorType.WARLOCK) {
                args = new Object[]{20};
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"item.%s.%s_armor.full_set_bonus".formatted("ebwizardry", this.wizardArmorType.name().toLowerCase()), (Object[])args).method_27692(class_124.field_1075));
        }
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1297 entity, int slotId, boolean isSelected) {
        if (level.field_9236) {
            return;
        }
        if (level.method_8510() % 40L != 0L) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (this.method_7685() == class_1304.field_6169 && InventoryUtil.isWearingFullSet(livingEntity, this.element, this.getWizardArmorType()) && InventoryUtil.doAllArmourPiecesHaveMana(livingEntity)) {
                if (this.getWizardArmorType() == WizardArmorType.WARLOCK) {
                    livingEntity.method_6092(new class_1293(class_1294.field_5904, 80, 0, false, false, false));
                    return;
                }
                if (this.getWizardArmorType() == WizardArmorType.BATTLEMAGE) {
                    livingEntity.method_6092(new class_1293(EBMobEffects.WARD.get(), 80, 0, false, false, false));
                }
            }
        }
    }

    protected void applySpellModifiers(class_1309 caster, Spell spell, SpellModifiers modifiers) {
        if (spell.getElement() == this.getElement()) {
            modifiers.set("cost", modifiers.get("cost") - this.getWizardArmorType().elementalCostReduction, false);
        }
        modifiers.set("potency", 2.0f, false);
        modifiers.set(EBItems.COOLDOWN_UPGRADE.get(), modifiers.get(EBItems.COOLDOWN_UPGRADE.get()) - this.getWizardArmorType().cooldownReduction, true);
        if (this.method_7685() == class_1304.field_6169 && InventoryUtil.isWearingFullSet(caster, this.element, this.getWizardArmorType()) && InventoryUtil.doAllArmourPiecesHaveMana(caster) && this.getWizardArmorType() == WizardArmorType.SAGE && spell.getElement() != this.element) {
            modifiers.set("cost", 0.8f, false);
        }
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        return this.getElement() == null ? super.method_7864(stack) : class_2561.method_43470((String)super.method_7864(stack).getString()).method_27692(this.getElement().getColor());
    }

    public WizardArmorType getWizardArmorType() {
        return this.wizardArmorType;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean validForReceptacle() {
        return false;
    }

    public int method_31571(@NotNull class_1799 stack) {
        return DrawingUtils.mix(16747518, 9318116, this.method_31569(stack));
    }

    @Override
    public int getMana(class_1799 stack) {
        return this.getManaCapacity(stack) - stack.method_7919();
    }

    @Override
    public void setMana(class_1799 stack, int mana) {
        stack.method_7974(this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getManaCapacity(class_1799 stack) {
        return this.method_7841();
    }

    @Override
    public int getSpellSlotCount(class_1799 stack) {
        return 0;
    }

    @Override
    public boolean showTooltip(class_1799 stack) {
        return true;
    }

    public boolean method_7878(@NotNull class_1799 toRepair, @NotNull class_1799 repair) {
        return false;
    }
}

