/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.loot;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBLootFunctions;
import com.binaris.wizardry.setup.registries.Spells;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_120;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomSpellFunction
extends class_120 {
    @Nullable
    private final List<Spell> spells;
    @Nullable
    private final List<Element> elements;
    @Nullable
    private final List<SpellTier> tiers;
    private final boolean ignoreWeighting;
    private final float undiscoveredBias;

    protected RandomSpellFunction(class_5341[] conditions, @Nullable List<Spell> spells, boolean ignoreWeighting, float undiscoveredBias, @Nullable List<SpellTier> tiers, @Nullable List<Element> elements) {
        super(conditions);
        this.spells = spells;
        this.ignoreWeighting = ignoreWeighting;
        this.undiscoveredBias = undiscoveredBias;
        this.tiers = tiers;
        this.elements = elements;
    }

    public static class_120.class_121<?> setRandomSpell(List<Spell> spells, boolean ignoreWeighting, float undiscoveredBias, List<SpellTier> tiers, List<Element> elements) {
        return RandomSpellFunction.method_520(conditions -> new RandomSpellFunction((class_5341[])conditions, spells, ignoreWeighting, undiscoveredBias, tiers, elements));
    }

    @NotNull
    public class_5339 method_29321() {
        return EBLootFunctions.RANDOM_SPELL;
    }

    @NotNull
    protected class_1799 method_522(class_1799 stack, @NotNull class_47 lootContext) {
        if (!(stack.method_7909() instanceof SpellBookItem) && !(stack.method_7909() instanceof ScrollItem)) {
            EBLogger.warn("Applying the random_spell loot function to an item that isn't a spell book or scroll.", new Object[0]);
        }
        SpellContext context = !lootContext.method_300(class_181.field_1226) ? SpellContext.TREASURE : SpellContext.LOOTING;
        class_1657 player = (class_1657)lootContext.method_296(class_181.field_1233);
        Spell spell = this.pickRandomSpell(stack, lootContext.method_294(), context, player);
        if (spell == Spells.NONE) {
            return SpellUtil.setSpell(stack, Spells.MAGIC_MISSILE);
        }
        return SpellUtil.setSpell(stack, spell);
    }

    private Spell pickRandomSpell(class_1799 stack, class_5819 random, SpellContext context, class_1657 player) {
        ArrayList<Spell> possibleSpells = new ArrayList<Spell>(Services.REGISTRY_UTIL.getSpells());
        if (this.spells != null && !this.spells.isEmpty()) {
            possibleSpells.retainAll(this.spells);
        }
        possibleSpells.removeIf(possibleSpell -> !possibleSpell.isEnabled(context));
        if (this.tiers != null && !this.tiers.isEmpty()) {
            possibleSpells.removeIf(possibleSpell -> !this.tiers.contains(possibleSpell.getTier()));
        }
        if (this.elements != null && !this.elements.isEmpty()) {
            possibleSpells.removeIf(possibleSpell -> !this.elements.contains(possibleSpell.getElement()));
        }
        if (stack.method_7909() instanceof SpellBookItem) {
            possibleSpells.removeIf(spell -> !spell.isEnabled(SpellContext.BOOK));
        }
        if (stack.method_7909() instanceof ScrollItem) {
            possibleSpells.removeIf(spell -> !spell.isEnabled(SpellContext.SCROLL));
        }
        if (player != null && this.undiscoveredBias > 0.0f) {
            float bias = this.undiscoveredBias;
            if (EBAccessoriesIntegration.isEquipped(player, EBItems.CHARM_SPELL_DISCOVERY.get())) {
                bias = Math.min(bias + 0.4f, 0.9f);
            }
            if (bias > 0.0f) {
                SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
                int discoveredCount = (int)possibleSpells.stream().filter(data::hasSpellBeenDiscovered).count();
                if (discoveredCount > 0 && discoveredCount < possibleSpells.size()) {
                    boolean keepDiscovered = random.method_43057() > 0.5f + 0.5f * this.undiscoveredBias;
                    possibleSpells.removeIf(s -> keepDiscovered != data.hasSpellBeenDiscovered((Spell)s));
                }
            }
        }
        if (possibleSpells.isEmpty()) {
            return Spells.NONE;
        }
        return possibleSpells.get(random.method_43048(possibleSpells.size()));
    }

    public static class Serializer
    extends class_120.class_123<RandomSpellFunction> {
        public void serialize(@NotNull JsonObject object, @NotNull RandomSpellFunction function, @NotNull JsonSerializationContext serializationContext) {
            DataResult result;
            if (function.spells != null && !function.spells.isEmpty()) {
                result = class_2960.field_25139.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, function.spells.stream().map(Spell::getLocation).collect(Collectors.toList()));
                result.result().ifPresent(jsonElement -> object.add("spells", jsonElement));
            }
            object.addProperty("ignore_weighting", Boolean.valueOf(function.ignoreWeighting));
            object.addProperty("undiscovered_bias", (Number)Float.valueOf(function.undiscoveredBias));
            if (function.tiers != null && !function.tiers.isEmpty()) {
                result = class_2960.field_25139.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, function.tiers.stream().map(SpellTier::getOrCreateLocation).collect(Collectors.toList()));
                result.result().ifPresent(jsonElement -> object.add("tiers", jsonElement));
            }
            if (function.elements != null && !function.elements.isEmpty()) {
                result = class_2960.field_25139.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, function.elements.stream().map(Element::getLocation).collect(Collectors.toList()));
                result.result().ifPresent(jsonElement -> object.add("elements", jsonElement));
            }
        }

        @NotNull
        public RandomSpellFunction deserialize(JsonObject object, @NotNull JsonDeserializationContext deserializationContext, class_5341 @NotNull [] conditions) {
            DataResult result;
            DataResult result2;
            List<Spell> spells = null;
            List tiers = null;
            List elements = null;
            if (object.has("spells") && (result2 = class_2960.field_25139.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("spells"))).result().isPresent()) {
                spells = ((List)result2.result().get()).stream().map(Services.REGISTRY_UTIL::getSpell).collect(Collectors.toList());
            }
            boolean ignoreWeighting = class_3518.method_15258((JsonObject)object, (String)"ignore_weighting", (boolean)false);
            float undiscoveredBias = class_3518.method_15277((JsonObject)object, (String)"undiscovered_bias", (float)0.0f);
            if (object.has("tiers") && (result = class_2960.field_25139.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("tiers"))).result().isPresent()) {
                tiers = ((List)result.result().get()).stream().map(Services.REGISTRY_UTIL::getTier).collect(Collectors.toList());
                if (tiers.contains(null)) {
                    EBLogger.warn("One or more invalid spell tiers found when deserializing random_spell loot function from " + object.toString(), new Object[0]);
                    tiers.removeIf(Objects::isNull);
                }
            }
            if (object.has("elements") && (result = class_2960.field_25139.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("elements"))).result().isPresent()) {
                elements = ((List)result.result().get()).stream().map(Services.REGISTRY_UTIL::getElement).collect(Collectors.toList());
                if (elements.contains(null)) {
                    EBLogger.warn("One or more invalid elements found when deserializing random_spell loot function from " + object.toString(), new Object[0]);
                    elements.removeIf(Objects::isNull);
                }
            }
            return new RandomSpellFunction(conditions, spells, ignoreWeighting, undiscoveredBias, tiers, elements);
        }
    }
}

