/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.menu;

import com.binaris.wizardry.api.content.event.SpellBindEvent;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.client.EBClientConstants;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.menu.slot.SlotItemClassList;
import com.binaris.wizardry.content.menu.slot.SlotItemList;
import com.binaris.wizardry.content.menu.slot.SlotWorkbenchItem;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.mixin.accessor.SlotAccessor;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMenus;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.HashSet;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcaneWorkbenchMenu
extends class_1703 {
    public static final int CRYSTAL_SLOT = 8;
    public static final int CENTRE_SLOT = 9;
    public static final int UPGRADE_SLOT = 10;
    public static final int SLOT_RADIUS = 42;
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public class_1263 container;
    public boolean needsRefresh;

    public ArcaneWorkbenchMenu(int i, class_1661 playerInv) {
        this(i, playerInv, (class_1263)new class_1277(11));
    }

    public ArcaneWorkbenchMenu(int id, class_1661 inventory, class_1263 container) {
        super(EBMenus.ARCANE_WORKBENCH_MENU.get(), id);
        this.container = container;
        class_1799 wand = container.method_5438(9);
        for (int i = 0; i < 8; ++i) {
            this.method_7621(new SlotItemClassList(container, i, -999, -999, 1, SpellBookItem.class));
        }
        this.method_7621(new SlotItemList(container, 8, 13, 101, 64, EBClientConstants.ARCANE_WORKBENCH_EMPTY_SLOT_CRYSTAL, EBItems.MAGIC_CRYSTAL.get(), EBItems.MAGIC_CRYSTAL_SHARD.get(), EBItems.MAGIC_CRYSTAL_GRAND.get(), EBItems.MAGIC_CRYSTAL_EARTH.get(), EBItems.MAGIC_CRYSTAL_FIRE.get(), EBItems.MAGIC_CRYSTAL_HEALING.get(), EBItems.MAGIC_CRYSTAL_ICE.get(), EBItems.MAGIC_CRYSTAL_LIGHTNING.get(), EBItems.MAGIC_CRYSTAL_NECROMANCY.get(), EBItems.MAGIC_CRYSTAL_SORCERY.get()));
        this.method_7621(new SlotWorkbenchItem(container, 9, 80, 64, this));
        HashSet<class_1792> upgrades = new HashSet<class_1792>(WandUpgrades.getSpecialUpgrades());
        upgrades.add(EBItems.ARCANE_TOME.get());
        upgrades.add(EBItems.RESPLENDENT_THREAD.get());
        upgrades.add(EBItems.CRYSTAL_SILVER_PLATING.get());
        upgrades.add(EBItems.ETHEREAL_CRYSTAL_WEAVE.get());
        this.method_7621(new SlotItemList(container, 10, 147, 17, 1, EBClientConstants.ARCANE_WORKBENCH_EMPTY_SLOT_UPGRADE, upgrades.toArray(new class_1792[0])));
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 8 + x * 18, 196));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, 9 + x + y * 9, 8 + x * 18, 138 + y * 18));
            }
        }
        this.onSlotChanged(9, wand, null);
    }

    private static int getBookSlotXOffset(int i, int bookSlotCount) {
        float angle = (float)i * ((float)Math.PI * 2) / (float)bookSlotCount;
        return Math.round(42.0f * class_3532.method_15374((float)angle));
    }

    private static int getBookSlotYOffset(int i, int bookSlotCount) {
        float angle = (float)i * ((float)Math.PI * 2) / (float)bookSlotCount;
        return Math.round(42.0f * -class_3532.method_15362((float)angle));
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        int[] slotRange;
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return itemstack;
        }
        class_1799 itemstack1 = slot.method_7677();
        itemstack = itemstack1.method_7972();
        if (index < 11 ? !this.method_7616(itemstack1, 11, 47, true) : index < 47 && (slotRange = this.findSlotRangeForItem(itemstack1)) != null && !this.method_7616(itemstack1, slotRange[0], slotRange[1] + 1, false)) {
            return class_1799.field_8037;
        }
        if (itemstack1.method_7960()) {
            slot.method_48931(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        if (itemstack1.method_7947() == itemstack.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7667(player, itemstack1);
        return itemstack;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.container.method_5443(player);
    }

    public void onSlotChanged(int slotNumber, class_1799 stack, class_1657 player) {
        if (slotNumber != 9) {
            return;
        }
        if (stack.method_7960()) {
            for (int i = 0; i < 8; ++i) {
                this.hideSlot(i, player);
            }
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IWorkbenchItem) {
            int i;
            IWorkbenchItem workbenchItem = (IWorkbenchItem)class_17922;
            int spellSlots = workbenchItem.getSpellSlotCount(stack);
            int centreX = this.method_7611((int)9).field_7873;
            int centreY = this.method_7611((int)9).field_7872;
            for (i = 0; i < spellSlots; ++i) {
                int x = centreX + ArcaneWorkbenchMenu.getBookSlotXOffset(i, spellSlots);
                int y = centreY + ArcaneWorkbenchMenu.getBookSlotYOffset(i, spellSlots);
                this.showSlot(i, x, y);
            }
            for (i = spellSlots; i < 8; ++i) {
                this.hideSlot(i, player);
            }
        }
    }

    public void onApplyButtonPressed(class_1657 player) {
        if (player.method_37908().field_9236) {
            return;
        }
        if (WizardryEventBus.getInstance().fire(new SpellBindEvent(player, this))) {
            return;
        }
        class_1735 centre = this.method_7611(9);
        class_1792 class_17922 = centre.method_7677().method_7909();
        if (class_17922 instanceof IWorkbenchItem) {
            IWorkbenchItem workbenchItem = (IWorkbenchItem)class_17922;
            class_1735[] spellBooks = this.field_7761.subList(0, 8).toArray(new class_1735[8]);
            if (workbenchItem.onApplyButtonPressed(player, centre, this.method_7611(8), this.method_7611(10), spellBooks) && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                EBAdvancementTriggers.ARCANE_WORKBENCH.trigger(serverPlayer, centre.method_7677());
            }
        }
    }

    public void onClearButtonPressed(class_1657 player) {
        class_1735 centre = this.method_7611(9);
        class_1792 class_17922 = centre.method_7677().method_7909();
        if (class_17922 instanceof IWorkbenchItem) {
            IWorkbenchItem workbenchItem = (IWorkbenchItem)class_17922;
            class_1735[] spellBooks = this.field_7761.subList(0, 8).toArray(new class_1735[8]);
            workbenchItem.onClearButtonPressed(player, centre, this.method_7611(8), this.method_7611(10), spellBooks);
        }
    }

    private void showSlot(int index, int x, int y) {
        class_1735 slot = this.method_7611(index);
        ((SlotAccessor)slot).setX(x);
        ((SlotAccessor)slot).setY(y);
    }

    private void hideSlot(int index, class_1657 player) {
        class_1735 slot = this.method_7611(index);
        ((SlotAccessor)slot).setX(-999);
        ((SlotAccessor)slot).setY(-999);
        class_1799 stack = slot.method_7677();
        class_1799 rest = this.method_7601(player, index);
        if (rest == class_1799.field_8037 && stack != class_1799.field_8037) {
            slot.method_7673(class_1799.field_8037);
            player.method_7328(stack, false);
        }
    }

    public int @Nullable [] findSlotRangeForItem(class_1799 stack) {
        if (this.method_7611(0).method_7680(stack)) {
            int spellSlots;
            class_1799 centreStack = this.method_7611(9).method_7677();
            if (centreStack.method_7909() instanceof IWorkbenchItem && (spellSlots = ((IWorkbenchItem)centreStack.method_7909()).getSpellSlotCount(centreStack)) > 0) {
                return new int[]{0, spellSlots - 1};
            }
        } else {
            if (this.method_7611(8).method_7680(stack)) {
                return new int[]{8, 8};
            }
            if (this.method_7611(9).method_7680(stack)) {
                return new int[]{9, 9};
            }
            if (this.method_7611(10).method_7680(stack)) {
                return new int[]{10, 10};
            }
        }
        return null;
    }
}

