/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public abstract class AreaEffectSpell
extends Spell {
    protected boolean targetAllies = false;
    protected boolean alwaysSucceed = false;
    protected float particleDensity = 0.65f;

    public AreaEffectSpell targetAllies(boolean targetAllies) {
        this.targetAllies = targetAllies;
        return this;
    }

    public AreaEffectSpell alwaysSucceed(boolean alwaysSucceed) {
        this.alwaysSucceed = alwaysSucceed;
        return this;
    }

    public AreaEffectSpell particleDensity(float particleDensity) {
        this.particleDensity = particleDensity;
        return this;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        boolean result = this.findAndAffectEntities(ctx, ctx.caster().method_19538());
        if (result) {
            this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        }
        return result;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        boolean result = this.findAndAffectEntities(ctx, ctx.caster().method_19538());
        if (result) {
            this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        }
        return result;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        boolean result = this.findAndAffectEntities(ctx, ctx.vec3());
        if (result) {
            this.playSound(ctx.world(), ctx.vec3(), ctx.castingTicks(), -1);
        }
        return result;
    }

    protected boolean findAndAffectEntities(CastContext ctx, class_243 origin) {
        double radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        List<class_1309> targets = EntityUtil.getLivingWithinRadius(radius, origin.field_1352, origin.field_1351, origin.field_1350, ctx.world());
        if (this.targetAllies) {
            targets.removeIf(target -> target != ctx.caster() && !AllyDesignation.isAllied(ctx.caster(), (class_1297)target));
        } else {
            targets.removeIf(target -> !AllyDesignation.isValidTarget((class_1297)ctx.caster(), (class_1297)target));
        }
        targets.sort(Comparator.comparingDouble(e -> e.method_5649(origin.field_1352, origin.field_1351, origin.field_1350)));
        boolean result = this.alwaysSucceed;
        int i = 0;
        for (class_1309 target2 : targets) {
            if (!this.affectEntity(ctx, origin, target2, i++)) continue;
            result = true;
        }
        if (ctx.world().field_9236) {
            this.spawnParticleEffect(ctx, origin, radius);
        }
        return result;
    }

    protected abstract boolean affectEntity(CastContext var1, class_243 var2, class_1309 var3, int var4);

    protected void spawnParticleEffect(CastContext ctx, class_243 origin, double radius) {
        int particleCount = (int)Math.round((double)this.particleDensity * Math.PI * radius * radius);
        for (int i = 0; i < particleCount; ++i) {
            double r = 1.0 + ctx.world().field_9229.method_43058() * (radius - 1.0);
            float angle = ctx.world().field_9229.method_43057() * (float)Math.PI * 2.0f;
            this.spawnParticle(ctx.world(), origin.field_1352 + r * (double)class_3532.method_15362((float)angle), origin.field_1351, origin.field_1350 + r * (double)class_3532.method_15374((float)angle));
        }
    }

    protected void spawnParticle(class_1937 world, double x, double y, double z) {
    }
}

