/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrowSpell<T extends MagicArrowEntity>
extends Spell {
    protected final Function<class_1937, T> arrowFactory;

    public ArrowSpell(Function<class_1937, T> arrowFactory) {
        this.arrowFactory = arrowFactory;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!ctx.world().field_9236) {
            MagicArrowEntity arrow = (MagicArrowEntity)((Object)this.arrowFactory.apply(ctx.world()));
            arrow.aim((class_1309)ctx.caster(), this.calculateVelocity(ctx, arrow, ctx.caster().method_5751()) - 0.3f);
            arrow.damageMultiplier = ctx.modifiers().get("potency");
            this.addArrowExtras(arrow, (class_1309)ctx.caster());
            ctx.world().method_8649((class_1297)arrow);
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() == null) {
            return false;
        }
        if (!ctx.world().field_9236) {
            MagicArrowEntity arrow = (MagicArrowEntity)((Object)this.arrowFactory.apply(ctx.world()));
            int aimingError = EntityUtil.getDefaultAimingError(ctx.world().method_8407());
            arrow.aim(ctx.caster(), (class_1297)ctx.target(), this.calculateVelocity(ctx, arrow, ctx.caster().method_5751() - 0.3f), aimingError);
            arrow.damageMultiplier = ctx.modifiers().get("potency");
            this.addArrowExtras(arrow, ctx.caster());
            ctx.world().method_8649((class_1297)arrow);
        }
        ctx.caster().method_6104(ctx.hand());
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!ctx.world().field_9236) {
            MagicArrowEntity arrow = (MagicArrowEntity)((Object)this.arrowFactory.apply(ctx.world()));
            arrow.method_33574(ctx.vec3());
            class_243 vec = class_243.method_24954((class_2382)ctx.direction().method_10163());
            arrow.method_7485(vec.method_10216(), vec.method_10214(), vec.method_10215(), this.calculateVelocity(ctx, arrow, 0.375f), 1.0f);
            arrow.damageMultiplier = ctx.modifiers().get("potency");
            this.addArrowExtras(arrow, null);
            ctx.world().method_8649((class_1297)arrow);
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    public float calculateVelocity(CastContext ctx, MagicArrowEntity projectile, float launchHeight) {
        float range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        if (projectile.method_5740()) {
            if (projectile.getLifetime() <= 0) {
                return 2.0f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.05f;
        return range / class_3532.method_15355((float)(2.0f * launchHeight / g));
    }

    protected void addArrowExtras(T arrow, @Nullable class_1309 caster) {
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

