/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;

public class BuffSpell
extends Spell {
    protected final Supplier<class_1291>[] effects;
    protected final float r;
    protected final float g;
    protected final float b;
    protected Set<class_1291> potionSet = new HashSet<class_1291>();
    protected float particleCount = 10.0f;

    @SafeVarargs
    public BuffSpell(float r, float g, float b, Supplier<class_1291> ... effects) {
        this.effects = effects;
        this.r = r;
        this.g = g;
        this.b = b;
        for (Supplier<class_1291> effect : effects) {
            this.potionSet.add(effect.get());
        }
    }

    public static int getStandardBonusAmplifier(float potencyModifier) {
        return (int)((double)(potencyModifier - 1.0f) / 0.4);
    }

    public static SpellProperty<Integer> getEffectDurationProperty(class_1291 effect) {
        return SpellProperty.intProperty(effect.method_5567() + "_duration");
    }

    public static SpellProperty<Integer> getEffectStrengthProperty(class_1291 effect) {
        return SpellProperty.intProperty(effect.method_5567() + "_strength");
    }

    public BuffSpell particleCount(int particleCount) {
        this.particleCount = particleCount;
        return this;
    }

    public Set<class_1291> getPotionSet() {
        return Collections.unmodifiableSet(this.potionSet);
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!this.applyEffects(ctx, (class_1309)ctx.caster())) {
            return false;
        }
        if (ctx.world().field_9236) {
            this.spawnParticles(ctx.world(), (class_1309)ctx.caster());
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (!this.potionSet.isEmpty() && ctx.caster().method_6088().keySet().containsAll(this.potionSet)) {
            return false;
        }
        if (!this.applyEffects(ctx, ctx.caster()) && !ctx.world().field_9236) {
            return false;
        }
        if (ctx.world().field_9236) {
            this.spawnParticles(ctx.world(), ctx.caster());
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        class_238 boundingBox = new class_238(ctx.pos());
        List entities = ctx.world().method_18467(class_1309.class, boundingBox);
        float distance = -1.0f;
        class_1309 nearestEntity = null;
        for (class_1309 entity : entities) {
            float newDistance = (float)entity.method_5649(ctx.x(), ctx.y(), ctx.z());
            if (distance != -1.0f && !(newDistance < distance)) continue;
            distance = newDistance;
            nearestEntity = entity;
        }
        if (nearestEntity == null) {
            return false;
        }
        if (!this.applyEffects(ctx, nearestEntity) && !ctx.world().field_9236) {
            return false;
        }
        if (ctx.world().field_9236) {
            this.spawnParticles(ctx.world(), nearestEntity);
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected boolean applyEffects(CastContext ctx, class_1309 caster) {
        int bonusAmplifier = this.getBonusAmplifier(ctx.modifiers().get("potency"));
        for (class_1291 effect : this.potionSet) {
            if (ctx.world().field_9236) continue;
            caster.method_6092(new class_1293(effect, effect.method_5561() ? 1 : (int)((float)this.property(BuffSpell.getEffectDurationProperty(effect)).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(BuffSpell.getEffectStrengthProperty(effect)) + bonusAmplifier, false, true));
        }
        return true;
    }

    protected void spawnParticles(class_1937 world, class_1309 caster) {
        int i = 0;
        while ((float)i < this.particleCount) {
            double x = caster.field_6014 + world.field_9229.method_43058() * 2.0 - 1.0;
            double y = caster.field_6036 + (double)caster.method_5751() - 0.5 + world.field_9229.method_43058();
            double z = caster.field_5969 + world.field_9229.method_43058() * 2.0 - 1.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.1, 0.0).color(this.r, this.g, this.b).spawn(world);
            ++i;
        }
        ParticleBuilder.create(EBParticles.BUFF).entity((class_1297)caster).color(this.r, this.g, this.b).spawn(world);
    }

    protected int getBonusAmplifier(float potencyModifier) {
        return BuffSpell.getStandardBonusAmplifier(potencyModifier);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

