/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class ConjureItemSpell
extends Spell {
    public static Set<class_1792> SUPPORTED_ITEMS = new HashSet<class_1792>();
    private final class_1792 item;

    public ConjureItemSpell(class_1792 item) {
        this.item = item;
        ConjureItemSpell.registerSupportedItem(item);
    }

    public static boolean isSummoned(class_1799 stack) {
        if (!ConjureItemSpell.isSummonableItem(stack)) {
            return false;
        }
        ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
        return data != null && data.isSummoned();
    }

    public static boolean isSummonableItem(class_1792 item) {
        return SUPPORTED_ITEMS.contains(item);
    }

    public static boolean isSummonableItem(class_1799 stack) {
        return ConjureItemSpell.isSummonableItem(stack.method_7909());
    }

    public static void registerSupportedItem(class_1792 item) {
        SUPPORTED_ITEMS.add(item);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (this.conjureItem(ctx)) {
            if (ctx.world().field_9236) {
                this.spawnParticles(ctx);
            }
            this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    protected void spawnParticles(PlayerCastContext ctx) {
        for (int i = 0; i < 10; ++i) {
            double x = ctx.caster().field_6014 + ctx.world().field_9229.method_43058() * 2.0 - 1.0;
            double y = ctx.caster().field_6036 + (double)ctx.caster().method_5751() - 0.5 + ctx.world().field_9229.method_43058();
            double z = ctx.caster().field_5969 + ctx.world().field_9229.method_43058() * 2.0 - 1.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.1, 0.0).color(0.7f, 0.9f, 1.0f).spawn(ctx.world());
        }
    }

    protected boolean conjureItem(PlayerCastContext ctx) {
        class_1799 stack = new class_1799((class_1935)this.item);
        stack = this.addItemExtras(ctx, stack);
        ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
        int duration = this.property(DefaultProperties.ITEM_LIFETIME);
        long currentGameTime = ctx.world().method_8510();
        data.setExpireTime(currentGameTime + (long)duration);
        data.setDuration(duration);
        data.setSummoned(true);
        if (!ctx.caster().method_7270(stack)) {
            ctx.caster().method_43496((class_2561)class_2561.method_43471((String)"spell.ebwizardry:conjure_item.no_space"));
            return false;
        }
        return true;
    }

    protected class_1799 addItemExtras(PlayerCastContext ctx, class_1799 stack) {
        return stack;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

