/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ConstructRangedSpell<T extends MagicConstructEntity>
extends ConstructSpell<T> {
    protected boolean hitLiquids = false;
    protected boolean ignoreUncollidables = false;

    public ConstructRangedSpell(Function<class_1937, T> constructFactory, boolean permanent) {
        super(constructFactory, permanent);
    }

    public Spell hitLiquids(boolean hitLiquids) {
        this.hitLiquids = hitLiquids;
        return this;
    }

    public Spell ignoreUncollidables(boolean ignoreUncollidables) {
        this.ignoreUncollidables = ignoreUncollidables;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cast(PlayerCastContext ctx) {
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        class_239 rayTrace = RayTracer.standardBlockRayTrace(ctx.world(), (class_1309)ctx.caster(), range, this.hitLiquids, this.ignoreUncollidables, false);
        if (rayTrace instanceof class_3965) {
            class_3965 blockTrace = (class_3965)rayTrace;
            class_2350 direction = blockTrace.method_17780();
            if (this.requiresFloor && !ctx.caster().method_24828()) {
                return false;
            }
            if (ctx.world().field_9236 || direction != class_2350.field_11036 && this.requiresFloor) return false;
            if (!this.spawnConstruct(ctx, blockTrace.method_17784(), direction)) {
                return false;
            }
        } else {
            if (this.requiresFloor || ctx.world().field_9236) return false;
            class_243 look = ctx.caster().method_5720();
            class_243 origin = ctx.caster().method_19538().method_1031(0.0, (double)ctx.caster().method_5751(), 0.0);
            class_243 target = origin.method_1019(look.method_1021(range));
            if (!this.spawnConstruct(ctx, target, null)) {
                return false;
            }
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        class_3965 blockHit;
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        if (ctx.target() == null) {
            return false;
        }
        if ((double)ctx.caster().method_5739((class_1297)ctx.target()) >= range || ctx.world().field_9236) {
            return false;
        }
        class_243 origin = ctx.caster().method_5836(1.0f);
        class_3965 hit = ctx.world().method_17742(new class_3959(origin, ctx.target().method_19538(), class_3959.class_3960.field_17558, this.hitLiquids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, null));
        if (hit instanceof class_3965 && !(blockHit = hit).method_17777().equals((Object)ctx.caster().method_24515())) {
            return false;
        }
        class_2350 side = null;
        int y = (int)ctx.target().method_23318();
        if (!ctx.target().method_24828() && this.requiresFloor) {
            Integer floor = BlockUtil.getNearestFloor(ctx.world(), ctx.target().method_24515(), 3);
            if (floor == null) {
                return false;
            }
            side = class_2350.field_11036;
            y = floor;
        }
        if (!this.spawnConstruct(ctx, new class_243(ctx.target().method_23317(), (double)y, ctx.target().method_23321()), side)) {
            return false;
        }
        ctx.caster().method_6104(ctx.hand());
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cast(LocationCastContext ctx) {
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        class_243 endpoint = ctx.vec3().method_1019(class_243.method_24954((class_2382)ctx.direction().method_10163()).method_1021(range));
        class_3965 rayTrace = ctx.world().method_17742(new class_3959(ctx.vec3(), endpoint, class_3959.class_3960.field_17558, this.hitLiquids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, null));
        if (rayTrace instanceof class_3965) {
            class_3965 blockHit = rayTrace;
            class_2350 direction = blockHit.method_17780();
            if (direction != class_2350.field_11036 && this.requiresFloor) return false;
            if (!ctx.world().field_9236 && !this.spawnConstruct(ctx, blockHit.method_17784(), direction)) {
                return false;
            }
        } else {
            if (this.requiresFloor || ctx.world().field_9236) return false;
            if (!this.spawnConstruct(ctx, endpoint, null)) {
                return false;
            }
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }
}

