/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructSpell<T extends MagicConstructEntity>
extends Spell {
    protected final Function<class_1937, T> constructFactory;
    protected final boolean permanent;
    protected boolean requiresFloor = false;
    protected boolean allowOverlap = false;

    public ConstructSpell(Function<class_1937, T> constructFactory, boolean permanent) {
        this.constructFactory = constructFactory;
        this.permanent = permanent;
    }

    public ConstructSpell<T> floor(boolean requiresFloor) {
        this.requiresFloor = requiresFloor;
        return this;
    }

    public ConstructSpell<T> overlap(boolean allowOverlap) {
        this.allowOverlap = allowOverlap;
        return this;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (ctx.caster().method_24828() || !this.requiresFloor) {
            if (!this.spawnConstruct(ctx, ctx.caster().method_19538(), (class_2350)(ctx.caster().method_24828() ? class_2350.field_11036 : null))) {
                return false;
            }
            this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() != null && (ctx.caster().method_24828() || !this.requiresFloor)) {
            if (!this.spawnConstruct(ctx, ctx.caster().method_19538(), (class_2350)(ctx.caster().method_24828() ? class_2350.field_11036 : null))) {
                return false;
            }
            this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        Integer floor = ctx.pos().method_10264();
        if (this.requiresFloor) {
            floor = BlockUtil.getNearestFloor(ctx.world(), ctx.pos(), 1);
            ctx.direction(class_2350.field_11036);
        }
        if (floor != null) {
            if (!this.spawnConstruct(ctx, new class_243(ctx.x(), (double)floor.intValue(), ctx.z()), ctx.direction())) {
                return false;
            }
            this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
            return true;
        }
        return false;
    }

    protected boolean spawnConstruct(CastContext ctx, class_243 vec3, @Nullable class_2350 side) {
        if (!ctx.world().field_9236) {
            MagicConstructEntity construct = (MagicConstructEntity)((Object)this.constructFactory.apply(ctx.world()));
            construct.method_33574(vec3);
            if (ctx.caster() != null) {
                construct.setCaster(ctx.caster());
            }
            construct.lifetime = this.permanent ? -1 : (int)((float)this.property(DefaultProperties.DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()));
            construct.damageMultiplier = ctx.modifiers().get("potency");
            if (construct instanceof ScaledConstructEntity) {
                ScaledConstructEntity scaledConstruct = (ScaledConstructEntity)construct;
                scaledConstruct.setSizeMultiplier(ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()));
            }
            this.addConstructExtras(construct, side, ctx.caster());
            if (!this.allowOverlap && !ctx.world().method_18467(((Object)((Object)construct)).getClass(), construct.method_5829()).isEmpty()) {
                return false;
            }
            ctx.world().method_8649((class_1297)construct);
        }
        return true;
    }

    protected void addConstructExtras(T construct, class_2350 side, @Nullable class_1309 caster) {
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

