/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionSpell<T extends class_1308>
extends Spell {
    public static final String HEALTH_MODIFIER = "minion_health";
    public static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    protected final Function<class_1937, T> minionFactory;
    protected boolean flying = false;
    protected boolean shouldFollowOwner = true;

    public MinionSpell(Function<class_1937, T> minionFactory) {
        this.minionFactory = minionFactory;
    }

    public MinionSpell<T> setShouldFollowOwner(boolean shouldFollowOwner) {
        this.shouldFollowOwner = shouldFollowOwner;
        return this;
    }

    public MinionSpell<T> flying(boolean flying) {
        this.flying = flying;
        return this;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!this.extraConditions(ctx, class_2338.method_49637((double)ctx.caster().field_6014, (double)ctx.caster().field_6036, (double)ctx.caster().field_5969))) {
            return false;
        }
        if (!this.spawnMinions(ctx)) {
            return false;
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (!this.extraConditions(ctx, class_2338.method_49637((double)ctx.caster().field_6014, (double)ctx.caster().field_6036, (double)ctx.caster().field_5969))) {
            return false;
        }
        if (!this.spawnMinions(ctx)) {
            return false;
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!this.extraConditions(ctx, ctx.pos())) {
            return false;
        }
        if (!ctx.world().field_9236) {
            for (int i = 0; i < this.property(DefaultProperties.MINION_COUNT); ++i) {
                class_1308 minion = (class_1308)this.minionFactory.apply(ctx.world());
                minion.method_5814((double)ctx.pos().method_10263() + 0.5, (double)ctx.pos().method_10264(), (double)ctx.pos().method_10260() + 0.5);
                this.setLifetime(minion, (int)(this.property(DefaultProperties.MINION_LIFETIME).floatValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
                this.addMinionExtras(minion, ctx, i);
                ctx.world().method_8649((class_1297)minion);
            }
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected boolean spawnMinions(CastContext ctx) {
        if (ctx.world().field_9236) {
            return true;
        }
        for (int i = 0; i < this.property(DefaultProperties.MINION_COUNT); ++i) {
            int range = this.property(DefaultProperties.SUMMON_RADIUS);
            class_2338 pos = BlockUtil.findNearbyFloorSpace((class_1297)ctx.caster(), range, range * 2);
            if (this.flying) {
                pos = pos != null ? pos.method_33096(2) : class_2338.method_49638((class_2374)ctx.caster().method_19538().method_43206(class_2350.field_11043, (double)(ctx.world().field_9229.method_43048(range * 2) - range)).method_43206(class_2350.field_11034, (double)(ctx.world().field_9229.method_43048(range * 2) - range)));
            } else if (pos == null) {
                return false;
            }
            T minion = this.createMinion(ctx.world(), ctx.caster(), ctx.modifiers());
            minion.method_5665((class_2561)class_2561.method_43469((String)"entity.ebwizardry.minion_name", (Object[])new Object[]{ctx.caster().method_5476(), minion.method_5476()}));
            MinionData data = Services.OBJECT_DATA.getMinionData((class_1308)minion);
            minion.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            data.setSummoned(true);
            data.setOwnerUUID(ctx.caster().method_5667());
            this.setLifetime(minion, (int)((float)this.property(DefaultProperties.MINION_LIFETIME).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
            data.setShouldFollowOwner(this.shouldFollowOwner);
            if (minion.method_5996(class_5134.field_23721) != null) {
                minion.method_5996(class_5134.field_23721).method_26837(new class_1322(POTENCY_ATTRIBUTE_MODIFIER, (double)(ctx.modifiers().get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), class_1322.class_1323.field_6331));
            }
            if (minion.method_5996(class_5134.field_23716) != null) {
                minion.method_5996(class_5134.field_23716).method_26837(new class_1322(HEALTH_MODIFIER, (double)(ctx.modifiers().get(HEALTH_MODIFIER) - 1.0f), class_1322.class_1323.field_6331));
            }
            minion.method_6033(minion.method_6063());
            minion.method_5943((class_5425)ctx.world(), ctx.world().method_8404(pos), class_3730.field_16471, null, null);
            this.addMinionExtras(minion, ctx, i);
            ctx.world().method_8649(minion);
        }
        return true;
    }

    private void setLifetime(T minion, int lifetime) {
        MinionData data = Services.OBJECT_DATA.getMinionData((class_1308)minion);
        data.setLifetime(lifetime);
    }

    protected T createMinion(class_1937 world, @Nullable class_1309 caster, SpellModifiers modifiers) {
        return (T)((class_1308)this.minionFactory.apply(world));
    }

    protected void addMinionExtras(T minion, CastContext ctx, int alreadySpawned) {
    }

    protected boolean extraConditions(CastContext ctx, class_2338 containing) {
        return true;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

