/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.entity.projectile.MagicProjectileEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectileSpell<T extends MagicProjectileEntity>
extends Spell {
    private static final float FALLBACK_VELOCITY = 1.5f;
    protected final Function<class_1937, T> projectileFactory;

    public ProjectileSpell(Function<class_1937, T> projectileFactory) {
        this.projectileFactory = projectileFactory;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!ctx.world().field_9236) {
            MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)this.projectileFactory.apply(ctx.world()));
            projectile.aim((class_1309)ctx.caster(), this.calculateVelocity(ctx, projectile, ctx.caster().method_5751() - 0.3f));
            projectile.damageMultiplier = ctx.modifiers().get("potency");
            if (projectile instanceof BombEntity) {
                BombEntity bomb = (BombEntity)projectile;
                bomb.blastMultiplier = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            }
            this.addProjectileExtras(projectile, (class_1309)ctx.caster());
            ctx.world().method_8649((class_1297)projectile);
        }
        ctx.caster().method_6104(ctx.hand());
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() == null) {
            return false;
        }
        if (!ctx.world().field_9236) {
            MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)this.projectileFactory.apply(ctx.world()));
            int aimingError = EntityUtil.getDefaultAimingError(ctx.world().method_8407());
            projectile.aim(ctx.caster(), (class_1297)ctx.target(), this.calculateVelocity(ctx, projectile, ctx.caster().method_5751() - 0.3f), aimingError);
            projectile.damageMultiplier = ctx.modifiers().get("potency");
            if (projectile instanceof BombEntity) {
                BombEntity bomb = (BombEntity)projectile;
                bomb.blastMultiplier = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            }
            this.addProjectileExtras(projectile, ctx.caster());
            ctx.world().method_8649((class_1297)projectile);
        }
        ctx.caster().method_6104(ctx.hand());
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!ctx.world().field_9236) {
            MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)this.projectileFactory.apply(ctx.world()));
            projectile.method_33574(ctx.vec3());
            class_2382 vec = ctx.direction().method_10163();
            projectile.method_7485(vec.method_10263(), vec.method_10264(), vec.method_10260(), this.calculateVelocity(ctx, projectile, 0.375f), 1.0f);
            projectile.damageMultiplier = ctx.modifiers().get("potency");
            if (projectile instanceof BombEntity) {
                BombEntity bomb = (BombEntity)projectile;
                bomb.blastMultiplier = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            }
            this.addProjectileExtras(projectile, null);
            ctx.world().method_8649((class_1297)projectile);
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected float calculateVelocity(CastContext ctx, MagicProjectileEntity projectile, float launchHeight) {
        float range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        if (projectile.method_5740()) {
            if (projectile.getLifeTime() <= 0) {
                return 1.5f;
            }
            return range / (float)projectile.getLifeTime();
        }
        float g = 0.05f;
        return range / class_3532.method_15355((float)(2.0f * launchHeight / g));
    }

    protected void addProjectileExtras(T projectile, @Nullable class_1309 caster) {
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

