/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public abstract class RaySpell
extends Spell {
    protected static final double Y_OFFSET = 0.25;
    protected double particleSpacing = 0.85;
    protected double particleJitter = 0.1;
    protected double particleVelocity = 0.0;
    protected boolean ignoreLivingEntities = false;
    protected boolean hitLiquids = false;
    protected boolean ignoreUncollidables = true;
    protected float aimAssist = 0.0f;

    public Spell particleSpacing(double particleSpacing) {
        this.particleSpacing = particleSpacing;
        return this;
    }

    public Spell particleJitter(double particleJitter) {
        this.particleJitter = particleJitter;
        return this;
    }

    public Spell particleVelocity(double particleVelocity) {
        this.particleVelocity = particleVelocity;
        return this;
    }

    public Spell ignoreLivingEntities(boolean ignoreLivingEntities) {
        this.ignoreLivingEntities = ignoreLivingEntities;
        return this;
    }

    public Spell hitLiquids(boolean hitLiquids) {
        this.hitLiquids = hitLiquids;
        return this;
    }

    public Spell ignoreUncollidables(boolean ignoreUncollidables) {
        this.ignoreUncollidables = ignoreUncollidables;
        return this;
    }

    public Spell aimAssist(float aimAssist) {
        this.aimAssist = aimAssist;
        return this;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        class_243 look = ctx.caster().method_5720();
        class_243 origin = new class_243(ctx.caster().method_23317(), ctx.caster().method_23318() + (double)ctx.caster().method_5751() - 0.25, ctx.caster().method_23321());
        if (this.isInstantCast() && ctx.world().field_9236 && ClientUtils.isFirstPerson((class_1297)ctx.caster())) {
            origin = origin.method_1019(look.method_1021(1.2));
        }
        if (!this.shootSpell(ctx, origin, look)) {
            return false;
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        class_243 origin = new class_243(ctx.caster().method_23317(), ctx.caster().method_23318() + (double)ctx.caster().method_5751() - 0.25, ctx.caster().method_23321());
        class_243 targetPos = null;
        if (ctx.target() != null) {
            if (!this.ignoreLivingEntities || !(ctx.target() instanceof class_1309)) {
                targetPos = new class_243(ctx.target().method_23317(), ctx.target().method_23318() + (double)(ctx.target().method_17682() / 2.0f), ctx.target().method_23321());
            } else {
                int x = class_3532.method_15357((double)ctx.target().method_23317());
                int y = (int)ctx.target().method_23318() - 1;
                int z = class_3532.method_15357((double)ctx.target().method_23321());
                class_2338 pos = new class_2338(x, y, z);
                if (!(ctx.world().method_22347(pos) || ctx.world().method_8320(pos).method_51176() && !this.hitLiquids)) {
                    targetPos = new class_243((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                }
            }
        }
        if (targetPos == null) {
            return false;
        }
        if (!this.shootSpell(ctx, origin, targetPos.method_1020(origin).method_1029())) {
            return false;
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        class_243 vec = new class_243(ctx.direction().method_23955());
        if (this.shootSpell(ctx, ctx.vec3(), vec)) {
            return false;
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected abstract boolean onMiss(CastContext var1, class_243 var2, class_243 var3);

    protected abstract boolean onBlockHit(CastContext var1, class_3965 var2, class_243 var3);

    protected abstract boolean onEntityHit(CastContext var1, class_3966 var2, class_243 var3);

    protected boolean shootSpell(CastContext ctx, class_243 origin, class_243 direction) {
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        class_243 endpoint = origin.method_1019(direction.method_1021(range));
        class_239 rayTrace = RayTracer.rayTrace(ctx.world(), (class_1297)ctx.caster(), origin, endpoint, this.aimAssist, this.hitLiquids, class_1297.class, this.ignoreLivingEntities ? EntityUtil::isLiving : RayTracer.ignoreEntityFilter((class_1297)ctx.caster()));
        boolean flag = false;
        if (rayTrace != null) {
            if (rayTrace instanceof class_3966) {
                class_3966 entityHit = (class_3966)rayTrace;
                flag = this.onEntityHit(ctx, entityHit, origin);
                if (flag) {
                    range = origin.method_1022(rayTrace.method_17784());
                }
            } else if (rayTrace instanceof class_3965) {
                class_3965 blockHit = (class_3965)rayTrace;
                flag = this.onBlockHit(ctx, blockHit, origin);
                range = origin.method_1022(rayTrace.method_17784());
            }
        }
        if (!flag && !this.onMiss(ctx, origin, direction)) {
            return false;
        }
        if (ctx.world().field_9236) {
            this.spawnParticleRay(ctx, origin, direction, range);
        }
        return true;
    }

    protected void spawnParticleRay(CastContext ctx, class_243 origin, class_243 direction, double distance) {
        class_243 velocity = direction.method_1021(this.particleVelocity);
        for (double d = this.particleSpacing; d <= distance; d += this.particleSpacing) {
            double x = origin.field_1352 + d * direction.field_1352 + this.particleJitter * (ctx.world().field_9229.method_43058() * 2.0 - 1.0);
            double y = origin.field_1351 + d * direction.field_1351 + this.particleJitter * (ctx.world().field_9229.method_43058() * 2.0 - 1.0);
            double z = origin.field_1350 + d * direction.field_1350 + this.particleJitter * (ctx.world().field_9229.method_43058() * 2.0 - 1.0);
            this.spawnParticle(ctx, x, y, z, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
    }
}

