/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class Fangs
extends Spell {
    private static final double FANG_SPACING = 1.25;

    public static void onHurt(EBLivingHurtEvent event) {
        if (event.getSource().method_5526() instanceof class_1669 && !AllyDesignation.isValidTarget(event.getSource().method_5529(), (class_1297)event.getDamagedEntity())) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (this.spawnFangs(ctx, ctx.caster().method_19538(), GeometryUtil.horizontalise(ctx.caster().method_5720()))) {
            return false;
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() == null) {
            return false;
        }
        if (this.spawnFangs(ctx, ctx.caster().method_19538(), ctx.target().method_19538().method_1020(ctx.caster().method_19538()).method_1029())) {
            return false;
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (this.spawnFangs(ctx, ctx.vec3(), class_243.method_24954((class_2382)ctx.direction().method_10163()))) {
            return false;
        }
        this.playSound(ctx.world(), ctx.vec3(), ctx.castingTicks(), -1);
        return true;
    }

    protected boolean spawnFangs(CastContext ctx, class_243 origin, class_243 direction) {
        class_1657 caster;
        class_1309 class_13092 = ctx.caster();
        boolean defensiveCircle = class_13092 instanceof class_1657 && (caster = (class_1657)class_13092).method_18276() && EBAccessoriesIntegration.isEquipped(caster, EBItems.RING_EVOKER.get());
        boolean flag = false;
        if (ctx.world().field_9236) {
            double x = origin.field_1352;
            double y = ctx.caster() != null ? origin.field_1351 + (double)ctx.caster().method_5751() : origin.field_1351;
            double z = origin.field_1350;
            for (int i = 0; i < 12; ++i) {
                ParticleBuilder.create(EBParticles.DARK_MAGIC, ctx.world().method_8409(), x, y, z, 0.5, false).color(0.4f, 0.3f, 0.35f).spawn(ctx.world());
            }
        }
        if (defensiveCircle) {
            float yaw;
            for (int i = 0; i < 5; ++i) {
                yaw = (float)i * (float)Math.PI * 0.4f;
                flag |= this.spawnFangsAt(ctx.world(), ctx.caster(), yaw, 0, ctx.caster().method_33571().method_1031((double)class_3532.method_15362((float)yaw) * 1.5, 0.0, (double)class_3532.method_15374((float)yaw) * 1.5));
            }
            for (int k = 0; k < 8; ++k) {
                yaw = (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                flag |= this.spawnFangsAt(ctx.world(), ctx.caster(), yaw, 3, ctx.caster().method_33571().method_1031((double)class_3532.method_15362((float)yaw) * 2.5, 0.0, (double)class_3532.method_15374((float)yaw) * 2.5));
            }
        } else {
            class_243 horizontal = GeometryUtil.horizontalise(ctx.caster().method_5720());
            int count = (int)(this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get()));
            float yaw = (float)class_3532.method_15349((double)horizontal.field_1350, (double)horizontal.field_1352);
            for (int i = 0; i < count; ++i) {
                class_243 vec = ctx.caster().method_33571().method_1019(horizontal.method_1021((double)(i + 1) * 1.25));
                flag |= this.spawnFangsAt(ctx.world(), ctx.caster(), yaw, i, vec);
            }
        }
        return !flag;
    }

    private boolean spawnFangsAt(class_1937 world, class_1309 caster, float yaw, int delay, class_243 vec) {
        Integer y = BlockUtil.getNearestFloor(world, class_2338.method_49638((class_2374)vec), 5);
        if (y != null) {
            class_1669 fangs = new class_1669(world, vec.field_1352, (double)y.intValue(), vec.field_1350, yaw, delay, caster);
            world.method_8649((class_1297)fangs);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.EARTH, SpellType.ATTACK, SpellAction.SUMMON, 40, 5, 60).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).build();
    }
}

