/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.content.spell.abstr.BuffSpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class ForestsCurse
extends AreaEffectSpell {
    public ForestsCurse() {
        this.alwaysSucceed(true);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    @Override
    protected boolean affectEntity(CastContext ctx, class_243 origin, class_1309 target, int targetCount) {
        if (!MagicDamageSource.isEntityImmune(EBDamageSources.POISON, (class_1297)target) && !ctx.world().field_9236) {
            class_1282 source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((class_1297)ctx.caster(), EBDamageSources.POISON) : target.method_48923().method_48831();
            target.method_5643(source, this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            int bonusAmplifier = BuffSpell.getStandardBonusAmplifier(ctx.modifiers().get("potency"));
            int duration = (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()));
            int amplifier = this.property(DefaultProperties.EFFECT_STRENGTH) + bonusAmplifier;
            target.method_6092(new class_1293(class_1294.field_5899, duration, amplifier));
            target.method_6092(new class_1293(class_1294.field_5909, duration, amplifier));
            target.method_6092(new class_1293(class_1294.field_5911, duration, amplifier));
        }
        return true;
    }

    @Override
    protected void spawnParticle(class_1937 world, double x, double y, double z) {
        float brightness = world.field_9229.method_43057() / 4.0f;
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y += 2.0, z).velocity(0.0, -0.2, 0.0).color(0.05f + brightness, 0.2f + brightness, 0.0f).spawn(world);
        brightness = world.field_9229.method_43057() / 4.0f;
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, -0.05, 0.0).time(50).color(0.1f + brightness, 0.2f + brightness, 0.0f).spawn(world);
        ParticleBuilder.create(EBParticles.LEAF).pos(x, y, z).velocity(0.0, -0.01, 0.0).time(40 + world.field_9229.method_43048(12)).spawn(world);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.EARTH, SpellType.ATTACK, SpellAction.POINT_UP, 75, 15, 200).add(DefaultProperties.EFFECT_RADIUS, 5).add(DefaultProperties.DAMAGE, Float.valueOf(4.0f)).add(DefaultProperties.EFFECT_DURATION, 140).add(DefaultProperties.EFFECT_STRENGTH, 2).build();
    }
}

