/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.fire;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class FireBreath
extends RaySpell {
    public FireBreath() {
        this.particleVelocity(1.0);
        this.particleJitter(0.3);
        this.particleSpacing(0.25);
        this.soundValues(3.0f, 1.0f, 0.0f);
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        if (!EntityUtil.canDamageBlocks(ctx.caster(), ctx.world())) {
            return false;
        }
        class_2338 pos = blockHit.method_17777().method_10093(blockHit.method_17780());
        if (ctx.world().method_22347(pos) && BlockUtil.canPlaceBlock(ctx.caster(), ctx.world(), pos)) {
            if (!ctx.world().field_9236) {
                ctx.world().method_8501(pos, class_2246.field_10036.method_9564());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        class_1309 target;
        class_1297 class_12972 = entityHit.method_17782();
        if (class_12972 instanceof class_1309 && !MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (class_1297)(target = (class_1309)class_12972))) {
            int n = ctx.castingTicks();
            Objects.requireNonNull(target);
            if (n % 20 == 1) {
                target.method_5639((int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
                class_1282 source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((class_1297)ctx.caster(), EBDamageSources.FIRE) : target.method_48923().method_48831();
                EntityUtil.attackEntityWithoutKnockback((class_1297)target, source, this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return true;
    }

    @Override
    protected void playSound(class_1937 world, class_1309 entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(EBParticles.MAGIC_FIRE).pos(x, y, z).velocity(vx, vy, vz).scale(2.0f + ctx.world().field_9229.method_43057()).collide(true).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.MAGIC_FIRE).pos(x, y, z).velocity(vx, vy, vz).scale(2.0f + ctx.world().field_9229.method_43057()).collide(true).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.FIRE, SpellType.ATTACK, SpellAction.POINT, 15, 15, 70).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(6.0f)).add(DefaultProperties.EFFECT_DURATION, 10).build();
    }
}

