/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.fire;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class Firestorm
extends AreaEffectSpell {
    public Firestorm() {
        this.soundValues(2.0f, 1.0f, 0.0f);
        this.alwaysSucceed(true);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        this.burnNearbyBlocks(ctx, ctx.caster().method_19538());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        this.burnNearbyBlocks(ctx, ctx.caster().method_19538());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        this.burnNearbyBlocks(ctx, ctx.vec3());
        return super.cast(ctx);
    }

    @Override
    public SpellAction getAction() {
        return SpellAction.POINT_DOWN;
    }

    @Override
    public int getCharge() {
        return 20;
    }

    @Override
    protected boolean affectEntity(CastContext ctx, class_243 origin, class_1309 target, int targetCount) {
        if (!MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (class_1297)target)) {
            target.method_5639(this.property(DefaultProperties.EFFECT_DURATION).intValue());
        }
        return true;
    }

    private void burnNearbyBlocks(CastContext ctx, class_243 origin) {
        if (ctx.world().field_9236 || !EntityUtil.canDamageBlocks(ctx.caster(), ctx.world())) {
            return;
        }
        double radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        for (int i = -((int)radius); i <= (int)radius; ++i) {
            for (int j = -((int)radius); j <= (int)radius; ++j) {
                class_2338 pos = new class_2338((int)origin.method_10216(), (int)origin.method_10214(), (int)origin.method_10215()).method_10069(i, 0, j);
                Integer y = BlockUtil.getNearestSurface(ctx.world(), new class_2338((class_2382)pos), class_2350.field_11036, (int)radius, true, BlockUtil.SurfaceCriteria.NOT_AIR_TO_AIR);
                if (y == null) continue;
                pos = new class_2338(pos.method_10263(), y.intValue(), pos.method_10260());
                double dist = origin.method_1022(new class_243(origin.field_1352 + (double)i, (double)y.intValue(), origin.field_1350 + (double)j));
                if (y == -1 || !((double)ctx.world().field_9229.method_43048((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !(dist > 1.5) || !BlockUtil.canPlaceBlock(ctx.caster(), ctx.world(), pos)) continue;
                ctx.world().method_8501(pos, class_2246.field_10036.method_9564());
            }
        }
    }

    @Override
    protected void spawnParticleEffect(CastContext ctx, class_243 origin, double radius) {
        double speed;
        float r;
        int i;
        for (i = 0; i < 100; ++i) {
            r = ctx.world().field_9229.method_43057();
            speed = 0.02 / (double)r * (1.0 + ctx.world().field_9229.method_43058());
            ParticleBuilder.create(EBParticles.MAGIC_FIRE).pos(origin.field_1352, origin.field_1351 + ctx.world().field_9229.method_43058() * 3.0, origin.field_1350).velocity(0.0, 0.0, 0.0).scale(2.0f).time(40 + ctx.world().field_9229.method_43048(10)).spin(ctx.world().field_9229.method_43058() * (radius - 0.5) + 0.5, speed).spawn(ctx.world());
        }
        for (i = 0; i < 60; ++i) {
            r = ctx.world().field_9229.method_43057();
            speed = 0.02 / (double)r * (1.0 + ctx.world().field_9229.method_43058());
            ParticleBuilder.create(EBParticles.CLOUD).pos(origin.field_1352, origin.field_1351 + ctx.world().field_9229.method_43058() * 2.5, origin.field_1350).color(DrawingUtils.mix(DrawingUtils.mix(16760320, 16725504, r / 0.6f), 0x222222, (r - 0.6f) / 0.4f)).spin((double)r * (radius - 1.0) + 0.5, speed).spawn(ctx.world());
        }
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.FIRE, SpellType.ATTACK, SpellAction.POINT_DOWN, 80, 20, 250).add(DefaultProperties.EFFECT_RADIUS, 6).add(DefaultProperties.EFFECT_DURATION, 15).build();
    }
}

