/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.healing;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class RayOfPurification
extends RaySpell {
    private static final SpellProperty<Float> UNDEAD_DAMAGE_MULTIPLIER = SpellProperty.floatProperty("undead_damage_multiplier", 2.0f);

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        class_1297 class_12972 = entityHit.method_17782();
        if (!(class_12972 instanceof class_1309)) {
            return false;
        }
        class_1309 target = (class_1309)class_12972;
        if (MagicDamageSource.isEntityImmune(EBDamageSources.RADIANT, (class_1297)target)) {
            if (!ctx.world().method_8608() && ctx.castingTicks() == 1) {
                ctx.caster().method_43496((class_2561)class_2561.method_43469((String)"spell.resist", (Object[])new Object[]{target.method_5477(), this.getDescriptionFormatted()}));
            }
            return false;
        }
        if (ctx.castingTicks() % 10 != 0) {
            return true;
        }
        float damage = this.property(UNDEAD_DAMAGE_MULTIPLIER).floatValue() * ctx.modifiers().get("potency");
        if (target.method_5999()) {
            damage *= this.property(UNDEAD_DAMAGE_MULTIPLIER).floatValue();
        }
        EntityUtil.attackEntityWithoutKnockback((class_1297)target, MagicDamageSource.causeDirectMagicDamage((class_1297)ctx.caster(), EBDamageSources.RADIANT), damage);
        if (!ctx.world().field_9236) {
            target.method_6092(new class_1293(class_1294.field_5919, (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()))));
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return true;
    }

    @Override
    protected void playSound(class_1937 world, class_1309 entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected void spawnParticleRay(CastContext ctx, class_243 origin, class_243 direction, double distance) {
        if (ctx.caster() != null) {
            ParticleBuilder.create(EBParticles.BEAM).entity((class_1297)ctx.caster()).pos(origin.method_1020(ctx.caster().method_19538())).length(distance).color(1.0f, 0.6f + 0.3f * ctx.world().field_9229.method_43057(), 0.2f).scale((float)(Math.sin((float)ctx.caster().field_6012 * 0.2f) * (double)0.1f + (double)1.4f)).spawn(ctx.world());
        } else {
            ParticleBuilder.create(EBParticles.BEAM).pos(origin).target(origin.method_1019(direction.method_1021(distance))).color(1.0f, 0.6f + 0.3f * ctx.world().field_9229.method_43057(), 0.2f).scale((float)(Math.sin((float)ClientUtils.getPlayer().field_6012 * 0.2f) * (double)0.1f + (double)1.4f)).spawn(ctx.world());
        }
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.HEALING, SpellType.ATTACK, SpellAction.POINT, 10, 10, 40).add(DefaultProperties.DAMAGE, Float.valueOf(2.0f)).add(DefaultProperties.EFFECT_DURATION, 100).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(UNDEAD_DAMAGE_MULTIPLIER).build();
    }
}

