/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1545;
import net.minecraft.class_1589;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class Freeze
extends RaySpell {
    public Freeze() {
        this.soundValues(1.0f, 1.4f, 0.4f);
        this.hitLiquids(true);
        this.ignoreUncollidables(false);
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        if (!ctx.world().field_9236 && BlockUtil.canPlaceBlock(ctx.caster(), ctx.world(), blockHit.method_17777())) {
            BlockUtil.freeze(ctx.world(), blockHit.method_17777(), true);
        }
        return true;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        class_1309 target;
        class_1297 class_12972 = entityHit.method_17782();
        if (!(class_12972 instanceof class_1309) || MagicDamageSource.isEntityImmune(EBDamageSources.FROST, (class_1297)(target = (class_1309)class_12972))) {
            return false;
        }
        if (target instanceof class_1545 || target instanceof class_1589) {
            class_1282 source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((class_1297)ctx.caster(), EBDamageSources.FROST) : target.method_48923().method_48831();
            target.method_5643(source, this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
        }
        if (ctx.world().field_9236) {
            return true;
        }
        target.method_6092(new class_1293(EBMobEffects.FROST.get(), (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        if (target.method_5809()) {
            target.method_5646();
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = 0.5f + ctx.world().field_9229.method_43057() / 2.0f;
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).time(12 + ctx.world().field_9229.method_43048(8)).color(brightness, brightness + 0.1f, 1.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SNOW).pos(x, y, z).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.NOVICE, Elements.ICE, SpellType.ATTACK, SpellAction.POINT, 5, 0, 10).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(3.0f)).add(DefaultProperties.EFFECT_DURATION, 200).add(DefaultProperties.EFFECT_STRENGTH, 1).build();
    }
}

