/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.entity.construct.IceBarrierConstruct;
import com.binaris.wizardry.setup.registries.EBEntities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class FrostBarrier
extends Spell {
    private static final double BARRIER_DISTANCE = 2.0;
    private static final double BARRIER_ARC_RADIUS = 10.0;
    private static final double BARRIER_SPACING = 1.4;

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (ctx.caster().method_24828()) {
            if (!this.createBarriers(ctx.world(), ctx.caster().method_19538(), ctx.caster().method_5720(), (class_1309)ctx.caster())) {
                return false;
            }
            this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.caster().method_24828()) {
            if (!this.createBarriers(ctx.world(), ctx.caster().method_19538(), ctx.target().method_19538().method_1020(ctx.caster().method_19538()), ctx.caster())) {
                return false;
            }
            this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!this.createBarriers(ctx.world(), ctx.vec3(), new class_243(ctx.direction().method_23955()), null)) {
            return false;
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().method_10148(), ctx.y() - (double)ctx.direction().method_10164(), ctx.z() - (double)ctx.direction().method_10165(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    private boolean createBarriers(class_1937 world, class_243 origin, class_243 direction, @Nullable class_1309 caster) {
        if (!world.field_9236) {
            direction = GeometryUtil.horizontalise(direction);
            class_243 centre = origin.method_1019(direction.method_1021(-8.0));
            ArrayList<IceBarrierConstruct> barriers = new ArrayList<IceBarrierConstruct>();
            int barrierCount = 3;
            for (int i = 0; i < barrierCount; ++i) {
                IceBarrierConstruct barrier = this.createBarrier(world, centre, direction.method_1024(0.14f * (float)i), caster, barrierCount, i);
                if (barrier != null) {
                    barriers.add(barrier);
                }
                if (i == 0 || (barrier = this.createBarrier(world, centre, direction.method_1024(-0.14f * (float)i), caster, barrierCount, i)) == null) continue;
                barriers.add(barrier);
            }
            if (barriers.isEmpty()) {
                return false;
            }
            barriers.forEach(arg_0 -> ((class_1937)world).method_8649(arg_0));
        }
        return true;
    }

    private IceBarrierConstruct createBarrier(class_1937 world, class_243 centre, class_243 direction, @Nullable class_1309 caster, int barrierCount, int index) {
        class_243 position = centre.method_1019(direction.method_1021(10.0));
        Integer floor = BlockUtil.getNearestFloor(world, class_2338.method_49638((class_2374)position), 3);
        if (floor == null) {
            return null;
        }
        position = GeometryUtil.replaceComponent(position, class_2350.class_2351.field_11052, floor.intValue());
        float scale = 1.5f - (float)index / (float)barrierCount * 0.5f;
        double yOffset = 1.5 * (double)scale;
        IceBarrierConstruct barrier = new IceBarrierConstruct(EBEntities.ICE_BARRIER.get(), world);
        barrier.method_5814(position.field_1352, position.field_1351 - yOffset, position.field_1350);
        barrier.setCaster(caster);
        barrier.lifetime = 400;
        barrier.damageMultiplier = 1.0f;
        barrier.method_5710((float)Math.toDegrees(class_3532.method_15349((double)(-direction.field_1352), (double)direction.field_1350)), barrier.method_36455());
        barrier.setSizeMultiplier(scale);
        barrier.setDelay(1 + 3 * index);
        if (!world.method_18467(barrier.getClass(), barrier.method_5829().method_989(0.0, yOffset, 0.0)).isEmpty()) {
            return null;
        }
        return barrier;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

