/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1545;
import net.minecraft.class_1589;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class FrostRay
extends RaySpell {
    public FrostRay() {
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        class_1309 target;
        class_1297 class_12972 = entityHit.method_17782();
        if (!(class_12972 instanceof class_1309) || MagicDamageSource.isEntityImmune(EBDamageSources.FROST, (class_1297)(target = (class_1309)class_12972))) {
            return false;
        }
        if (target.method_5809()) {
            target.method_5646();
        }
        if (ctx.world().field_9236) {
            return true;
        }
        target.method_6092(new class_1293(EBMobEffects.FROST.get(), this.property(DefaultProperties.EFFECT_DURATION).intValue(), this.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        int n = ctx.castingTicks();
        Objects.requireNonNull(target);
        if (n % 20 == 1) {
            float damage = this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency");
            if (target instanceof class_1545 || target instanceof class_1589) {
                damage *= 2.0f;
            }
            class_1282 source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((class_1297)ctx.caster(), EBDamageSources.FROST) : target.method_48923().method_48831();
            EntityUtil.attackEntityWithoutKnockback((class_1297)target, source, damage);
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        return false;
    }

    @Override
    public int getCharge() {
        return 20;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = ctx.world().field_9229.method_43057();
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().field_9229.method_43048(12)).color(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).collide(true).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SNOW).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().field_9229.method_43048(12)).collide(true).spawn(ctx.world());
    }

    @Override
    protected void playSound(class_1937 world, class_1309 entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.ICE, SpellType.ATTACK, SpellAction.POINT, 5, 0, 0).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(3.0f)).add(DefaultProperties.EFFECT_DURATION, 200).add(DefaultProperties.EFFECT_STRENGTH, 0).build();
    }
}

