/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import javax.annotation.Nullable;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class IceAge
extends AreaEffectSpell {
    private static final SpellProperty<Integer> FREEZE_DURATION = SpellProperty.intProperty("freeze_duration", 1200);

    public IceAge() {
        this.soundValues(1.5f, 1.0f, 0.0f);
        this.alwaysSucceed(true);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        this.freezeNearbyBlocks(ctx.world(), ctx.caster().method_19538(), (class_1309)ctx.caster(), ctx.modifiers());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        this.freezeNearbyBlocks(ctx.world(), ctx.vec3(), null, ctx.modifiers());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        this.freezeNearbyBlocks(ctx.world(), ctx.caster().method_19538(), ctx.caster(), ctx.modifiers());
        return super.cast(ctx);
    }

    @Override
    protected boolean affectEntity(CastContext ctx, class_243 origin, class_1309 target, int targetCount) {
        target.method_6092(new class_1293(EBMobEffects.FROST.get(), (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        target.method_5783(EBSounds.MISC_FREEZE.get(), 1.0f, ctx.world().field_9229.method_43057() * 0.4f + 0.8f);
        return true;
    }

    @Override
    protected void spawnParticleEffect(CastContext ctx, class_243 origin, double radius) {
        double speed;
        float r;
        int i;
        class_5819 random = ctx.world().field_9229;
        for (i = 0; i < 100; ++i) {
            r = random.method_43057();
            speed = 0.02 / (double)r * (1.0 + random.method_43058());
            ParticleBuilder.create(EBParticles.SNOW).pos(origin.field_1352, origin.field_1351 + random.method_43058() * 3.0, origin.field_1350).velocity(0.0, 0.0, 0.0).spin(random.method_43058() * (radius - 0.5) + 0.5, speed).shaded(true).scale(2.0f).spawn(ctx.world());
        }
        for (i = 0; i < 60; ++i) {
            r = random.method_43057();
            speed = 0.02 / (double)r * (1.0 + random.method_43058());
            ParticleBuilder.create(EBParticles.CLOUD).pos(origin.field_1352, origin.field_1351 + random.method_43058() * 2.5, origin.field_1350).spin(random.method_43058() * (radius - 1.0) + 0.5, speed).color(0xFFFFFF).shaded(true).spawn(ctx.world());
        }
    }

    private void freezeNearbyBlocks(class_1937 world, class_243 origin, @Nullable class_1309 caster, SpellModifiers modifiers) {
        if (world.method_8608() || !EntityUtil.canDamageBlocks(caster, world)) {
            return;
        }
        double radius = this.property(DefaultProperties.EFFECT_RADIUS).floatValue() * modifiers.get(EBItems.BLAST_UPGRADE.get());
        for (int i = -((int)radius); i <= (int)radius; ++i) {
            for (int j = -((int)radius); j <= (int)radius; ++j) {
                class_2338 pos = class_2338.method_49638((class_2374)origin).method_10069(i, 0, j);
                Integer y = BlockUtil.getNearestSurface(world, new class_2338((class_2382)pos), class_2350.field_11036, (int)radius, true, BlockUtil.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                if (y == null) continue;
                pos = new class_2338(pos.method_10263(), y.intValue(), pos.method_10260());
                double dist = origin.method_1022(new class_243(origin.field_1352 + (double)i, (double)y.intValue(), origin.field_1350 + (double)j));
                if (y == -1 || !((double)world.field_9229.method_43048((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !BlockUtil.canPlaceBlock(caster, world, pos)) continue;
                BlockUtil.freeze(world, pos.method_10074(), true);
            }
        }
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.ICE, SpellType.ATTACK, SpellAction.POINT_DOWN, 70, 20, 250).add(DefaultProperties.EFFECT_RADIUS, 7).add(FREEZE_DURATION).add(DefaultProperties.EFFECT_DURATION, 400).add(DefaultProperties.EFFECT_STRENGTH, 1).build();
    }
}

