/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.entity.construct.IceSpikeConstruct;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructRangedSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IceSpickes
extends ConstructRangedSpell<IceSpikeConstruct> {
    public IceSpickes() {
        super(IceSpikeConstruct::new, true);
        this.ignoreUncollidables(true);
    }

    @Override
    protected boolean spawnConstruct(CastContext ctx, class_243 origin, @Nullable class_2350 side) {
        if (side == null) {
            return false;
        }
        class_2338 blockHit = class_2338.method_49638((class_2374)origin);
        if (side.method_10171() == class_2350.class_2352.field_11060) {
            blockHit = blockHit.method_10093(side);
        }
        if (ctx.world().method_8320(blockHit).method_26234((class_1922)ctx.world(), blockHit)) {
            return false;
        }
        class_243 pos = origin.method_1019(new class_243(side.method_10153().method_23955()));
        super.spawnConstruct(ctx, pos, side);
        int quantity = (int)((float)Spells.ICE_SPICKES.property(DefaultProperties.ENTITIES).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()) - 1.0f);
        float maxRadius = (float)Spells.ICE_SPICKES.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        for (int i = 0; i < quantity; ++i) {
            Integer surface;
            double radius = 0.5 + ctx.world().field_9229.method_43058() * ((double)maxRadius - 0.5);
            class_243 offset = class_243.method_1030((float)(ctx.world().field_9229.method_43057() * 180.0f - 90.0f), (float)(ctx.world().field_9229.method_43056() ? 0.0f : 180.0f)).method_1021(radius).method_1024(side.method_10144() * (float)Math.PI / 180.0f).method_1037(GeometryUtil.getPitch(side) * (float)Math.PI / 180.0f);
            if (side.method_10166().method_10179()) {
                offset = offset.method_1024(1.5707964f);
            }
            if ((surface = BlockUtil.getNearestSurface(ctx.world(), new class_2338((class_2382)class_2338.method_49638((class_2374)origin.method_1019(offset))), side, (int)maxRadius, true, BlockUtil.SurfaceCriteria.basedOn(this::isCollisionShapeFullBlock))) == null) continue;
            class_243 vec = GeometryUtil.replaceComponent(origin.method_1019(offset), side.method_10166(), surface.intValue()).method_1020(new class_243(side.method_23955()));
            super.spawnConstruct(ctx, vec, side);
        }
        return true;
    }

    public boolean isCollisionShapeFullBlock(class_1922 blockGetter, class_2338 pos) {
        return blockGetter.method_8320(pos).method_26234(blockGetter, pos);
    }

    @Override
    protected void addConstructExtras(IceSpikeConstruct construct, class_2350 side, @Nullable class_1309 caster) {
        construct.lifetime = 30 + construct.method_37908().field_9229.method_43048(15);
        construct.setFacing(side);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.ICE, SpellType.ATTACK, SpellAction.POINT, 30, 0, 75).add(DefaultProperties.RANGE, Float.valueOf(20.0f)).add(DefaultProperties.EFFECT_RADIUS, 3).add(DefaultProperties.ENTITIES, 18).add(DefaultProperties.DAMAGE, Float.valueOf(5.0f)).add(DefaultProperties.EFFECT_DURATION, 100).add(DefaultProperties.EFFECT_STRENGTH, 0).build();
    }
}

