/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.EBConstants;
import com.binaris.wizardry.setup.registries.EBBlocks;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class Permafrost
extends RaySpell {
    public Permafrost() {
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
        this.soundValues(0.5f, 1.0f, 0.0f);
        this.ignoreLivingEntities(true);
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        boolean flag = false;
        if (!ctx.world().field_9236) {
            int blastUpgradeCount = (int)((ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()) - 1.0f) / EBConstants.BLAST_RADIUS_INCREASE_PER_LEVEL + 0.5f);
            float radius = 0.5f + 0.73f * (float)blastUpgradeCount;
            int duration = (int)((float)this.property(DefaultProperties.DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()));
            List<class_2338> sphere = BlockUtil.getBlockSphere(blockHit.method_17777().method_10084(), radius);
            for (class_2338 pos1 : sphere) {
                flag |= this.tryToPlaceIce(ctx.world(), pos1, ctx.caster(), duration);
            }
            return flag;
        }
        return true;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return true;
    }

    private boolean tryToPlaceIce(class_1937 world, class_2338 pos, class_1309 caster, int duration) {
        if (world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos.method_10074(), class_2350.field_11036) && BlockUtil.canBlockBeReplaced(world, pos) && BlockUtil.canPlaceBlock(caster, world, pos)) {
            world.method_8501(pos, EBBlocks.PERMAFROST.get().method_9564());
            world.method_39279(pos.method_10062(), EBBlocks.PERMAFROST.get(), duration);
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    protected void playSound(class_1937 world, class_1309 entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = ctx.world().field_9229.method_43057();
        ParticleBuilder.create(EBParticles.DUST).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().field_9229.method_43048(12)).color(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SNOW).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().field_9229.method_43048(12)).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.ICE, SpellType.ALTERATION, SpellAction.POINT, 10, 10, 40).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(3.0f)).add(DefaultProperties.DURATION, 600).add(DefaultProperties.EFFECT_DURATION, 100).add(DefaultProperties.EFFECT_STRENGTH, 0).build();
    }
}

