/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.lightning;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.Persistence;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;

public class Charge
extends Spell {
    public static final ISpellVar<SpellModifiers> CHARGE_MODIFIERS = new ISpellVar.SpellVar<SpellModifiers>(Persistence.NEVER);
    public static final SpellProperty<Float> CHARGE_SPEED = SpellProperty.floatProperty("charge_speed");
    public static final ISpellVar<Integer> CHARGE_TIME = new ISpellVar.SpellVar<Integer>(Persistence.NEVER).withTicker(Charge::update);

    public Charge() {
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    private static int update(class_1657 player, Integer chargeTime) {
        if (chargeTime == null) {
            chargeTime = 0;
        }
        if (chargeTime > 0 && !player.method_37908().field_9236) {
            SpellModifiers modifiers = Services.OBJECT_DATA.getSpellManagerData(player).getVariable(CHARGE_MODIFIERS);
            if (modifiers == null) {
                modifiers = new SpellModifiers();
            }
            class_243 look = player.method_5720();
            float speed = Spells.CHARGE.property(CHARGE_SPEED).floatValue() * modifiers.get(EBItems.RANGE_UPGRADE.get());
            player.method_18800(look.field_1352 * (double)speed, player.method_18798().field_1351, look.field_1350 * (double)speed);
            if (player.method_37908().field_9236) {
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create(EBParticles.SPARK, (class_1297)player).spawn(player.method_37908());
                }
            }
            List collided = player.method_37908().method_18467(class_1309.class, player.method_5829().method_1014(1.0));
            collided.remove(player);
            float damage = Spells.CHARGE.property(DefaultProperties.DAMAGE).floatValue() * modifiers.get("potency");
            float knockback = Spells.CHARGE.property(DefaultProperties.KNOCKBACK).floatValue();
            collided.forEach(e -> e.method_5643(MagicDamageSource.causeDirectMagicDamage((class_1297)player, EBDamageSources.SHOCK), damage));
            collided.forEach(e -> e.method_5762(player.method_18798().field_1352 * (double)knockback, player.method_18798().field_1351 * (double)knockback + (double)0.3f, player.method_18798().field_1350 * (double)knockback));
            if (player.method_37908().field_9236) {
                player.method_37908().method_8406((class_2394)class_2398.field_11221, player.method_23317() + player.method_18798().field_1352, player.method_23318() + (double)(player.method_17682() / 2.0f), player.method_23321() + player.method_18798().field_1350, 0.0, 0.0, 0.0);
            }
            if (collided.isEmpty()) {
                Integer n = chargeTime;
                chargeTime = chargeTime - 1;
            } else {
                EntityUtil.playSoundAtPlayer(player, class_3417.field_14940, 1.0f, 1.0f);
                chargeTime = 0;
            }
            player.field_6037 = true;
        }
        return chargeTime;
    }

    public static void onLivingHurt(EBLivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        class_1309 class_13092 = event.getDamagedEntity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            class_13092 = event.getSource().method_5529();
            if (class_13092 instanceof class_1309) {
                class_1309 attacker = class_13092;
                SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
                Integer chargeTime = data.getVariable(CHARGE_TIME);
                if (chargeTime != null && chargeTime > 0 && player.method_5829().method_1014(1.0).method_994(attacker.method_5829())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(ctx.caster());
        data.setVariable(CHARGE_TIME, (int)(this.property(DefaultProperties.DURATION).floatValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
        data.setVariable(CHARGE_MODIFIERS, ctx.modifiers());
        if (ctx.world().field_9236) {
            ctx.world().method_8406((class_2394)class_2398.field_11221, ctx.caster().method_23317(), ctx.caster().method_23318() + (double)(ctx.caster().method_17682() / 2.0f), ctx.caster().method_23321(), 0.0, 0.0, 0.0);
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.LIGHTNING, SpellType.ATTACK, SpellAction.POINT, 20, 0, 50).add(CHARGE_SPEED, Float.valueOf(2.0f)).add(DefaultProperties.DURATION, 10).add(DefaultProperties.DAMAGE, Float.valueOf(8.0f)).add(DefaultProperties.KNOCKBACK, Float.valueOf(1.0f)).build();
    }
}

