/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.lightning;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class LightningPulse
extends Spell {
    private static final SpellProperty<Float> REPULSION_VELOCITY = SpellProperty.floatProperty("repulsion_velocity", 0.8f);

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!ctx.caster().method_24828()) {
            return false;
        }
        float radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        List<class_1309> targets = EntityUtil.getLivingWithinRadius(radius, ctx.caster().method_23317(), ctx.caster().method_23318(), ctx.caster().method_23321(), ctx.world());
        targets.removeIf(t -> !AllyDesignation.isValidTarget((class_1297)ctx.caster(), (class_1297)t));
        for (class_1309 target : targets) {
            target.method_5643(MagicDamageSource.causeDirectMagicDamage((class_1297)ctx.caster(), EBDamageSources.SHOCK), this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            if (ctx.world().method_8608()) continue;
            double dx = target.method_23317() - ctx.caster().method_23317();
            double dz = target.method_23321() - ctx.caster().method_23321();
            double vectorLength = Math.sqrt(dx * dx + dz * dz);
            target.method_18800((double)this.property(REPULSION_VELOCITY).floatValue() * (dx /= vectorLength), 0.0, (double)this.property(REPULSION_VELOCITY).floatValue() * (dz /= vectorLength));
            if (!(target instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)target;
            serverPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)target));
        }
        if (ctx.world().method_8608()) {
            ParticleBuilder.create(EBParticles.LIGHTNING_PULSE).pos(ctx.caster().method_23317(), ctx.caster().method_23318() + 0.005, ctx.caster().method_23321()).scale(ctx.modifiers().get(EBItems.BLAST_UPGRADE.get())).spawn(ctx.world());
        }
        this.playSound(ctx.world(), (class_1309)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.LIGHTNING, SpellType.ATTACK, SpellAction.POINT_DOWN, 25, 0, 75).add(DefaultProperties.DAMAGE, Float.valueOf(8.0f)).add(DefaultProperties.EFFECT_RADIUS, 3).add(REPULSION_VELOCITY).add(DefaultProperties.SENSIBLE, true).build();
    }
}

