/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class Banish
extends RaySpell {
    public static final SpellProperty<Integer> MINIMUM_TELEPORT = SpellProperty.intProperty("minimum_teleport_distance", 8);
    public static final SpellProperty<Integer> MAX_TELEPORT = SpellProperty.intProperty("maximum_teleport_distance", 16);

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        class_1297 class_12972 = entityHit.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            double minRadius = this.property(MINIMUM_TELEPORT).intValue();
            double maxRadius = this.property(MAX_TELEPORT).intValue();
            double radius = (minRadius + ctx.world().field_9229.method_43058() * maxRadius - minRadius) * (double)ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            this.teleport(target, ctx.world(), radius);
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ctx.world().method_8406((class_2394)class_2398.field_11214, x, y - 0.5, z, 0.0, 0.0, 0.0);
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.2f, 0.0f, 0.2f).spawn(ctx.world());
    }

    public void teleport(class_1309 entity, class_1937 world, double radius) {
        float angle = world.field_9229.method_43057() * (float)Math.PI * 2.0f;
        int x = class_3532.method_15357((double)(entity.method_23317() + (double)class_3532.method_15374((float)angle) * radius));
        int z = class_3532.method_15357((double)(entity.method_23321() - (double)class_3532.method_15362((float)angle) * radius));
        Integer y = BlockUtil.getNearestFloor(world, new class_2338(x, (int)entity.method_23318(), z), (int)radius);
        if (world.field_9236) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = entity.method_23317();
                double dy1 = entity.method_23318() + (double)(entity.method_17682() * world.field_9229.method_43057());
                double dz1 = entity.method_23321();
                world.method_8406((class_2394)class_2398.field_11214, dx1, dy1, dz1, world.field_9229.method_43058() - 0.5, world.field_9229.method_43058() - 0.5, world.field_9229.method_43058() - 0.5);
            }
        }
        if (y != null) {
            if (!world.method_8320(new class_2338(x, y.intValue(), z)).method_51366()) {
                Integer n = y;
                y = y - 1;
            }
            if (world.method_8320(new class_2338(x, y + 1, z)).method_51366() || world.method_8320(new class_2338(x, y + 2, z)).method_51366()) {
                return;
            }
            if (!world.field_9236) {
                entity.method_24203((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            this.playSound(world, entity, 0, -1);
        }
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.ATTACK, SpellAction.POINT, 75, 0, 40).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(MINIMUM_TELEPORT).add(MAX_TELEPORT).build();
    }
}

