/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.IStoredSpellVar;
import com.binaris.wizardry.api.content.data.Persistence;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.api.content.util.NBTExtras;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class CurseOfSoulbinding
extends RaySpell {
    public static final IStoredSpellVar<Set<UUID>> TARGETS_KEY = new IStoredSpellVar.StoredSpellVar<Set, class_2499>("soulboundCreatures", s -> NBTExtras.listToTag(s, class_2512::method_25929), t -> new HashSet<UUID>(NBTExtras.tagToList(t, class_2512::method_25930)), Persistence.DIMENSION_CHANGE);

    public CurseOfSoulbinding() {
        this.soundValues(1.0f, 1.1f, 0.2f);
        Services.OBJECT_DATA.spellStoredVariables(TARGETS_KEY);
    }

    public static Set<UUID> getSoulboundCreatures(SpellManagerData data) {
        if (data.getVariable(TARGETS_KEY) == null) {
            HashSet<UUID> result = new HashSet<UUID>();
            data.setVariable(TARGETS_KEY, result);
            return result;
        }
        return data.getVariable(TARGETS_KEY);
    }

    public static void onLivingHurt(EBLivingHurtEvent event) {
        class_1309 class_13092;
        if (!event.getDamagedEntity().method_37908().field_9236 && (class_13092 = event.getDamagedEntity()) instanceof class_1657) {
            class_1657 playerDamaged = (class_1657)class_13092;
            SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(playerDamaged);
            Iterator<UUID> iterator = CurseOfSoulbinding.getSoulboundCreatures(data).iterator();
            while (iterator.hasNext()) {
                class_1297 entity = EntityUtil.getEntityByUUID(playerDamaged.method_37908(), iterator.next());
                if (entity == null || entity instanceof class_1309 && !((class_1309)entity).method_6059(EBMobEffects.CURSE_OF_SOULBINDING.get())) {
                    iterator.remove();
                    continue;
                }
                if (!(entity instanceof class_1309) || !entity.method_5643(MagicDamageSource.causeDirectMagicDamage((class_1297)playerDamaged, EBDamageSources.SORCERY), event.getAmount())) continue;
                entity.method_5783(EBSounds.SPELL_CURSE_OF_SOULBINDING_RETALIATE.get(), 1.0f, playerDamaged.method_37908().field_9229.method_43057() * 0.2f + 1.0f);
            }
        }
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        class_1297 class_12972 = entityHit.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 livingTarget = (class_1309)class_12972;
            class_12972 = ctx.caster();
            if (class_12972 instanceof class_1657) {
                class_1657 caster = (class_1657)class_12972;
                SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(caster);
                if (CurseOfSoulbinding.getSoulboundCreatures(data).add(livingTarget.method_5667())) {
                    livingTarget.method_6092(new class_1293(EBMobEffects.CURSE_OF_SOULBINDING.get(), Integer.MAX_VALUE));
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.4f, 0.0f, 0.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.1f, 0.0f, 0.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).time(12 + ctx.world().field_9229.method_43048(8)).color(1.0f, 0.8f, 1.0f).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.ALTERATION, SpellAction.POINT, 35, 10, 100).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).build();
    }
}

