/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.entity.construct.DecayConstruct;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructRangedSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Decay
extends ConstructRangedSpell<DecayConstruct> {
    public static final SpellProperty<Integer> PATCHES_SPAWNED = SpellProperty.intProperty("decay_patches_spawned", 5);

    public Decay() {
        super(DecayConstruct::new, false);
    }

    @Override
    protected boolean spawnConstruct(CastContext ctx, class_243 vec3, @Nullable class_2350 side) {
        class_2338 pos;
        class_2338 origin = class_2338.method_49638((class_2374)vec3);
        if (ctx.world().method_8320(origin).method_26234((class_1922)ctx.world(), origin)) {
            return false;
        }
        super.spawnConstruct(ctx, vec3, side);
        float decayCount = this.property(PATCHES_SPAWNED).intValue();
        int quantity = (int)(decayCount * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()));
        int horizontalRange = (int)(0.4 * (double)decayCount * (double)ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()));
        int verticalRange = (int)(6.0f * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()));
        for (int i = 0; i < quantity && (pos = BlockUtil.findNearbyFloorSpace(ctx.world(), origin, horizontalRange, verticalRange, false)) != null; ++i) {
            super.spawnConstruct(ctx, new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5), side);
        }
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.DEFENCE, SpellAction.POINT, 35, 0, 80).add(DefaultProperties.RANGE, Float.valueOf(12.0f)).add(DefaultProperties.DURATION, 400).add(DefaultProperties.EFFECT_DURATION, 400).add(PATCHES_SPAWNED).build();
    }
}

