/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1678;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

public class ShulkerBullet
extends Spell {
    @Override
    public boolean cast(PlayerCastContext ctx) {
        return this.shoot(ctx.world(), (class_1309)ctx.caster(), ctx.caster().method_23317(), ctx.caster().method_23318(), ctx.caster().method_23321(), ctx.castingTicks(), ctx.modifiers());
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        return this.shoot(ctx.world(), ctx.caster(), ctx.caster().method_23317(), ctx.caster().method_23318(), ctx.caster().method_23321(), ctx.castingTicks(), ctx.modifiers());
    }

    private boolean shoot(class_1937 world, class_1309 caster, double x, double y, double z, int castingTicks, SpellModifiers modifiers) {
        if (!world.field_9236) {
            double range = this.property(DefaultProperties.RANGE).floatValue() * modifiers.get(EBItems.RANGE_UPGRADE.get());
            List<class_1309> possibleTargets = EntityUtil.getLivingWithinRadius(range, x, y, z, world);
            possibleTargets.remove(caster);
            possibleTargets.removeIf(t -> t instanceof class_1531);
            if (possibleTargets.isEmpty()) {
                return false;
            }
            possibleTargets.sort(Comparator.comparingDouble(t -> t.method_5649(x, y, z)));
            class_1297 target = (class_1297)possibleTargets.get(0);
            world.method_8649((class_1297)new class_1678(world, caster, target, class_2350.field_11036.method_10166()));
            this.playSound(world, caster, castingTicks, -1);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.PROJECTILE, SpellAction.POINT_DOWN, 25, 0, 40).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).build();
    }
}

