/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.event.EBPlayerBreakBlockEvent;
import com.binaris.wizardry.api.content.event.EBPlayerUseBlockEvent;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class ArcaneLockSpell
extends RaySpell {
    public static void onPlayerUseBlock(EBPlayerUseBlockEvent event) {
        if (event.getLevel().method_8608()) {
            return;
        }
        class_2586 blockEntity = event.getLevel().method_8321(event.getPos());
        if (!(blockEntity instanceof class_2624)) {
            return;
        }
        class_2624 containerBlock = (class_2624)blockEntity;
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((class_2586)containerBlock);
        if (data == null) {
            return;
        }
        if (data.isArcaneLocked() && !data.getArcaneLockOwnerUUID().equals(event.getPlayer().method_5667())) {
            event.getPlayer().method_7353((class_2561)class_2561.method_43471((String)"spell.ebwizardry.arcane_lock.not_owning").method_27692(class_124.field_1076), true);
            event.setCanceled(true);
        }
    }

    public static void onPlayerBreakBlock(EBPlayerBreakBlockEvent event) {
        if (event.getLevel().method_8608()) {
            return;
        }
        class_2586 blockEntity = event.getLevel().method_8321(event.getPos());
        if (!(blockEntity instanceof class_2624)) {
            return;
        }
        class_2624 containerBlock = (class_2624)blockEntity;
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((class_2586)containerBlock);
        if (data == null) {
            return;
        }
        if (data.isArcaneLocked() && !data.getArcaneLockOwnerUUID().equals(event.getPlayer().method_5667())) {
            event.getPlayer().method_7353((class_2561)class_2561.method_43471((String)"spell.ebwizardry.arcane_lock.not_owning").method_27692(class_124.field_1076), true);
            event.setCanceled(true);
        }
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, class_3965 blockHit, class_243 origin) {
        class_2338 pos;
        class_1309 class_13092 = ctx.caster();
        if (!(class_13092 instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)class_13092;
        if (!ctx.world().field_9236 && this.toggleLock(ctx, pos = blockHit.method_17777(), player)) {
            class_2338 otherHalf = ArcaneLockSpell.getConnectedChest(ctx.world(), pos);
            if (otherHalf != null) {
                this.toggleLock(ctx, otherHalf, player);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, class_243 origin, class_243 direction) {
        return false;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, class_3966 entityHit, class_243 origin) {
        return false;
    }

    private boolean toggleLock(CastContext ctx, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = ctx.world().method_8321(pos);
        if (!(blockEntity instanceof class_2624)) {
            return false;
        }
        class_2624 containerBlock = (class_2624)blockEntity;
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((class_2586)containerBlock);
        if (data == null) {
            return false;
        }
        if (data.isArcaneLocked()) {
            if (data.getArcaneLockOwnerUUID().equals(player.method_5667())) {
                data.setArcaneLockOwner(null);
                player.method_7353((class_2561)class_2561.method_43471((String)"spell.ebwizardry.arcane_lock.unlocking").method_27692(class_124.field_1076), true);
                return true;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"spell.ebwizardry.arcane_lock.not_owning").method_27692(this.getElement().getColor()), true);
            return false;
        }
        data.setArcaneLockOwner(player.method_5667().toString());
        blockEntity.method_5431();
        ctx.world().method_8413(pos, ctx.world().method_8320(pos), ctx.world().method_8320(pos), 3);
        player.method_7353((class_2561)class_2561.method_43471((String)"spell.ebwizardry.arcane_lock.locking").method_27692(class_124.field_1076), true);
        return true;
    }

    private static class_2338 getConnectedChest(class_1937 level, class_2338 pos) {
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (!(class_22482 instanceof class_2281)) {
            return null;
        }
        class_2281 chest = (class_2281)class_22482;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 pos1 = pos.method_10081(direction.method_10163());
            if (level.method_8320(pos1).method_26204() != chest) continue;
            return pos1;
        }
        return null;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.SORCERY, SpellType.UTILITY, SpellAction.POINT, 50, 0, 100).add(DefaultProperties.RANGE, Float.valueOf(8.0f)).build();
    }
}

