/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PhaseStep
extends Spell {
    public static final SpellProperty<Integer> WALL_THICKNESS = SpellProperty.intProperty("wall_thickness", 1);

    @Override
    public boolean cast(PlayerCastContext ctx) {
        class_1657 caster = ctx.caster();
        class_1937 world = ctx.world();
        boolean teleportMount = caster.method_5854() != null && EBAccessoriesIntegration.isEquipped(caster, EBItems.CHARM_MOUNT_TELEPORTING.get());
        double range = this.property(DefaultProperties.RANGE).floatValue();
        int maxThickness = this.property(WALL_THICKNESS);
        class_243 start = caster.method_33571();
        class_243 direction = caster.method_5720();
        if (world.field_9236) {
            for (int i = 0; i < 10; ++i) {
                double x = caster.method_23317();
                double y = caster.method_23318() + (double)(2.0f * world.field_9229.method_43057());
                double z = caster.method_23321();
                world.method_8406((class_2394)class_2398.field_11214, x, y, z, world.field_9229.method_43058() - 0.5, world.field_9229.method_43058() - 0.5, world.field_9229.method_43058() - 0.5);
            }
        }
        class_1657 subject = teleportMount ? caster.method_5854() : caster;
        class_2338 lastChecked = null;
        int wallThickness = 0;
        boolean inWall = false;
        for (double dist = 1.0; dist <= range; dist += 0.5) {
            boolean isBlocked;
            class_243 checkPoint = start.method_1019(direction.method_1021(dist));
            class_2338 checkPos = class_2338.method_49638((class_2374)checkPoint);
            if (lastChecked != null && lastChecked.equals((Object)checkPos)) continue;
            lastChecked = checkPos;
            boolean bl = isBlocked = !BlockUtil.isBlockPassable(world, checkPos) || !BlockUtil.isBlockPassable(world, checkPos.method_10084());
            if (isBlocked) {
                if (!inWall) {
                    inWall = true;
                    wallThickness = 1;
                } else {
                    ++wallThickness;
                }
                if (wallThickness <= maxThickness) continue;
                break;
            }
            if (inWall) {
                class_243 dest = new class_243((double)checkPos.method_10263() + 0.5, (double)checkPos.method_10264(), (double)checkPos.method_10260() + 0.5);
                if (this.attemptTeleport(world, (class_1297)subject, dest, teleportMount, caster)) {
                    return true;
                }
                inWall = false;
                wallThickness = 0;
                continue;
            }
            if (!(dist >= range - 0.5)) continue;
            class_243 destination = new class_243((double)checkPos.method_10263() + 0.5, (double)checkPos.method_10264(), (double)checkPos.method_10260() + 0.5);
            return this.attemptTeleport(world, (class_1297)subject, destination, teleportMount, caster);
        }
        return false;
    }

    protected boolean attemptTeleport(class_1937 world, class_1297 toTeleport, class_243 destination, boolean teleportMount, class_1657 caster) {
        class_243 resolved = EntityUtil.findSpaceForTeleport(toTeleport, destination, teleportMount);
        if (resolved == null) {
            return false;
        }
        this.playSound(world, (class_1309)caster, 0, -1);
        if (!teleportMount && caster.method_5854() != null) {
            caster.method_5848();
        }
        if (!world.field_9236) {
            if (toTeleport instanceof class_3222) {
                class_3222 sp = (class_3222)toTeleport;
                sp.method_5859(resolved.field_1352, resolved.field_1351, resolved.field_1350);
            } else {
                toTeleport.method_5814(resolved.field_1352, resolved.field_1351, resolved.field_1350);
            }
        }
        this.playSound(world, (class_1309)caster, 0, -1);
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.SORCERY, SpellType.UTILITY, SpellAction.POINT, 35, 0, 40).add(WALL_THICKNESS).add(DefaultProperties.RANGE, Float.valueOf(8.0f)).build();
    }
}

