/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.sorcery;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class SpeedTime
extends Spell {
    public static final SpellProperty<Float> TIME_INCREMENT = SpellProperty.floatProperty("time_increment", 30.0f);
    public static final SpellProperty<Integer> EXTRA_TICKS = SpellProperty.intProperty("extra_ticks", 1);

    public SpeedTime() {
        this.soundValues(0.4f, 1.0f, 0.0f);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        class_1937 world = ctx.world();
        class_1657 caster = ctx.caster();
        boolean didAnything = false;
        float blastMod = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        if (!world.field_9236) {
            long advance = (long)(this.property(TIME_INCREMENT).floatValue() * blastMod);
            ((class_3218)world).method_29199(world.method_8532() + advance);
            didAnything = true;
        }
        double radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * blastMod;
        int potencyLevel = (int)(((ctx.modifiers().get("potency") - 1.0f) * 2.0f + 1.0f) * (float)this.property(EXTRA_TICKS).intValue());
        List<class_1297> entities = EntityUtil.getEntitiesWithinRadius(radius, caster.method_23317(), caster.method_23318(), caster.method_23321(), world, class_1297.class);
        if (!entities.isEmpty()) {
            entities.removeIf(e -> e instanceof class_1657);
            if (!entities.isEmpty()) {
                for (int i = 0; i < potencyLevel; ++i) {
                    for (class_1297 e2 : entities) {
                        e2.method_5773();
                    }
                }
                didAnything = true;
            }
        }
        if (!world.field_9236) {
            List<class_2338> sphere = BlockUtil.getBlockSphere(caster.method_24515(), radius);
            for (class_2338 pos : sphere) {
                class_2680 state = world.method_8320(pos);
                if (!state.method_26229()) continue;
                for (int i = 0; i < potencyLevel; ++i) {
                    state.method_26199((class_3218)world, pos, world.field_9229);
                }
            }
        }
        if (world.field_9236) {
            double x = caster.method_23317() + 2.0;
            double y = caster.method_23318() + (double)(caster.method_17682() / 2.0f);
            double z = caster.method_23321();
            for (int i = 0; i < 2; ++i) {
                ParticleBuilder.create(EBParticles.SPARKLE, world.field_9229, x, y, z, 2.0, false).velocity(-0.25, 0.0, 0.0).time(16).color(1.0f, 1.0f, 1.0f).spawn(world);
                ParticleBuilder.create(EBParticles.FLASH, world.field_9229, x, y, z, 2.0, false).velocity(-0.25, 0.0, 0.0).time(16).scale(0.5f).color(0.6f + world.field_9229.method_43057() * 0.4f, 0.6f + world.field_9229.method_43057() * 0.4f, 0.6f + world.field_9229.method_43057() * 0.4f).spawn(world);
            }
        }
        this.playSound(world, (class_1309)caster, ctx.castingTicks(), -1);
        return didAnything;
    }

    @Override
    protected void playSound(class_1937 world, class_1309 entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(class_1937 world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.SORCERY, SpellType.UTILITY, SpellAction.POINT_UP, 15, 0, 0).add(DefaultProperties.EFFECT_RADIUS).add(TIME_INCREMENT).add(EXTRA_TICKS).build();
    }
}

