/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static boolean meleeRing(class_1282 source, Element element) {
        WandItem wand;
        class_1309 living;
        class_1297 class_12972;
        return !source.method_48790() && (class_12972 = source.method_5529()) instanceof class_1309 && (class_12972 = (living = (class_1309)class_12972).method_6047().method_7909()) instanceof WandItem && (wand = (WandItem)class_12972).getElement() == element;
    }

    public static boolean findMatchingWandAndCast(class_1657 player, Spell spell) {
        return ArtifactUtils.findMatchingWandAndExecute(player, spell, wand -> {
            SpellModifiers modifiers = new SpellModifiers();
            if (((ISpellCastingItem)wand.method_7909()).canCast((class_1799)wand, spell, new PlayerCastContext(player.method_37908(), player, class_1268.field_5808, 0, modifiers))) {
                ((ISpellCastingItem)wand.method_7909()).cast((class_1799)wand, spell, new PlayerCastContext(player.method_37908(), player, class_1268.field_5808, 0, modifiers));
            }
        });
    }

    public static boolean findMatchingWandAndExecute(class_1657 player, Spell spell, Consumer<? super class_1799> action) {
        List<class_1799> hotbar = InventoryUtil.getHotBarAndOffhand(player);
        Optional<class_1799> stack = hotbar.stream().filter(s -> s.method_7909() instanceof ISpellCastingItem && Arrays.asList(((ISpellCastingItem)s.method_7909()).getSpells((class_1799)s)).contains(spell)).findFirst();
        stack.ifPresent(action);
        return stack.isPresent();
    }

    public static void handleLightningEffect(class_1297 player, class_1309 target, EBLivingHurtEvent event) {
        if (player.method_37908().field_9236) {
            ParticleBuilder.create(EBParticles.LIGHTNING).entity((class_1297)event.getDamagedEntity()).pos(0.0, event.getDamagedEntity().method_17682() / 2.0f, 0.0).target((class_1297)target).spawn(player.method_37908());
            ParticleBuilder.spawnShockParticles(player.method_37908(), target.method_23317(), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321());
        }
        target.method_5643(MagicDamageSource.causeDirectMagicDamage(player, EBDamageSources.SHOCK), Spells.STATIC_AURA.property(DefaultProperties.DAMAGE).floatValue());
        target.method_5783(EBSounds.SPELL_STATIC_AURA_RETALIATE.get(), 1.0f, player.method_37908().field_9229.method_43057() * 0.4f + 1.5f);
    }
}

