/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.ImbuementEnchantData;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.EBEntityJoinLevelEvent;
import com.binaris.wizardry.api.content.event.EBItemPlaceInContainerEvent;
import com.binaris.wizardry.api.content.event.EBItemTossEvent;
import com.binaris.wizardry.api.content.event.EBLivingDeathEvent;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.event.EBPlayerInteractEntityEvent;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.content.spell.abstr.ConjureItemSpell;
import com.binaris.wizardry.core.platform.Services;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class DataEvents {
    private static final int CONJURE_CHECK_INTERVAL = 20;
    private static final int IMBUEMENT_ENCHANTS_CHECK_INTERVAL = 20;

    private DataEvents() {
    }

    public static void onMinionTick(EBLivingTick event) {
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1308)) {
            return;
        }
        class_1308 mob = (class_1308)class_13092;
        if (!Services.OBJECT_DATA.isMinion((class_1297)mob)) {
            return;
        }
        Services.OBJECT_DATA.getMinionData(mob).tick();
    }

    public static void onConjureToss(EBItemTossEvent event) {
        ConjureData data;
        class_1799 stack = event.getStack();
        if (ConjureItemSpell.isSummoned(stack) && (data = Services.OBJECT_DATA.getConjureData(stack)) != null && data.isSummoned()) {
            event.setCanceled(true);
        }
    }

    public static void onConjureEntityDeath(EBLivingDeathEvent event) {
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        InventoryUtil.getAllItems(player).stream().filter(ConjureItemSpell::isSummoned).forEach(stack -> stack.method_7934(stack.method_7947()));
    }

    public static void onConjureItemPlaceInContainer(EBItemPlaceInContainerEvent event) {
        class_1799 stack = event.getStack();
        if (ConjureItemSpell.isSummoned(stack) && !(event.getContainer() instanceof class_1661)) {
            event.setCanceled(true);
        }
    }

    public static void onPlayerTick(EBLivingTick event) {
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        if (player.method_29504()) {
            return;
        }
        DataEvents.spellDataTick(player);
        DataEvents.castCommandTick(player);
        DataEvents.conjureItemTick(player);
        DataEvents.recentSpells(player);
        DataEvents.temporaryEnchantmentTick(player);
    }

    private static void spellDataTick(class_1657 player) {
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        Map<ISpellVar, Object> spellData = data.getSpellData();
        spellData.replaceAll((k, v) -> k.update(player, v));
        spellData.entrySet().removeIf(entry -> ((ISpellVar)entry.getKey()).canPurge(player, entry.getValue()));
    }

    public static void onMinionJoinLevel(EBEntityJoinLevelEvent event) {
        class_1308 mob;
        class_1297 class_12972 = event.getEntity();
        if (class_12972 instanceof class_1308 && Services.OBJECT_DATA.isMinion((class_1297)(mob = (class_1308)class_12972))) {
            Services.OBJECT_DATA.getMinionData(mob).markGoalRestart(true);
        }
    }

    public static void onPlayerInteractMinion(EBPlayerInteractEntityEvent event) {
        class_1308 mob;
        class_1297 class_12972 = event.getTarget();
        if (class_12972 instanceof class_1308 && Services.OBJECT_DATA.isMinion((class_1297)(mob = (class_1308)class_12972))) {
            event.setCanceled(true);
        }
    }

    private static void castCommandTick(class_1657 player) {
        CastCommandData castData = Services.OBJECT_DATA.getCastCommandData(player);
        castData.tick();
    }

    private static void temporaryEnchantmentTick(class_1657 player) {
        if (player.method_37908().method_8510() % 20L != 0L) {
            return;
        }
        long currentGameTime = player.method_37908().method_8510();
        for (class_1799 stack : InventoryUtil.getAllItems(player)) {
            Map<class_2960, Long> tempEnchants;
            ImbuementEnchantData data;
            if (stack.method_7960() || class_1890.method_8222((class_1799)stack).isEmpty() || (data = Services.OBJECT_DATA.getImbuementData(stack)) == null || (tempEnchants = data.getImbuements()).isEmpty()) continue;
            Map currentEnchants = class_1890.method_8222((class_1799)stack);
            boolean changed = false;
            for (Map.Entry<class_2960, Long> entry : tempEnchants.entrySet()) {
                class_1887 enchantment;
                long expireTime = entry.getValue();
                if (expireTime < 0L || currentGameTime < expireTime || (enchantment = (class_1887)class_7923.field_41176.method_10223(entry.getKey())) == null) continue;
                currentEnchants.remove(enchantment);
                data.removeImbuement(enchantment);
                changed = true;
            }
            if (!changed) continue;
            class_1890.method_8214((Map)currentEnchants, (class_1799)stack);
        }
    }

    private static void conjureItemTick(class_1657 player) {
        if (player.field_6012 % 20 != 0) {
            return;
        }
        long currentGameTime = player.method_37908().method_8510();
        InventoryUtil.getAllItems(player).stream().filter(ConjureItemSpell::isSummoned).forEach(stack -> DataEvents.checkAndExpireItem(stack, currentGameTime));
    }

    private static void checkAndExpireItem(class_1799 stack, long currentGameTime) {
        ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
        if (data != null && data.hasExpired(currentGameTime)) {
            stack.method_7934(1);
            data.setSummoned(false);
        }
    }

    private static void recentSpells(class_1657 player) {
        WizardData data = Services.OBJECT_DATA.getWizardData(player);
        if (player.field_6012 % 60 == 0) {
            long currentTime = player.method_37908().method_8510();
            data.removeRecentCasts(entry -> currentTime - (Long)entry.getValue() >= 1200L);
        }
    }
}

