/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.core.platform.Services;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PropertiesDataManager
extends class_4309 {
    public static final Gson GSON = class_5270.method_27861().create();
    protected static final Logger LOGGER = LogManager.getLogger();
    public static PropertiesDataManager INSTANCE;

    public PropertiesDataManager() {
        super(GSON, "spells");
    }

    protected void apply(Map<class_2960, JsonElement> resourceList, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> entry : resourceList.entrySet()) {
            class_2960 location = entry.getKey();
            try {
                Spell spell = Services.REGISTRY_UTIL.getSpell(location);
                if (spell == null) {
                    LOGGER.warn("No spell found with ID {}, skipping loading of its properties", (Object)location);
                    continue;
                }
                SpellProperties properties = SpellProperties.fromJson(class_3518.method_15295((JsonElement)entry.getValue(), (String)location.toString()));
                if (properties == null) {
                    LOGGER.info("Skipping loading spell properties {} as it's serializer returned null", (Object)location);
                    continue;
                }
                spell.setProperties(properties);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading spell properties {}", (Object)location, (Object)jsonParseException);
            }
            catch (Exception exception) {
                LOGGER.error("Unexpected error loading spell properties {}", (Object)location, (Object)exception);
            }
        }
    }
}

