/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.event;

import com.binaris.wizardry.core.event.EventListener;
import com.binaris.wizardry.core.event.EventRegistry;
import com.binaris.wizardry.core.event.IWizardryEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WizardryEventBus
implements EventRegistry {
    private static final WizardryEventBus INSTANCE = new WizardryEventBus();
    private final Map<Class<? extends IWizardryEvent>, List<EventListener<? extends IWizardryEvent>>> listeners = new HashMap<Class<? extends IWizardryEvent>, List<EventListener<? extends IWizardryEvent>>>();

    public static WizardryEventBus getInstance() {
        return INSTANCE;
    }

    @Override
    public synchronized <E extends IWizardryEvent> void register(Class<E> eventClass, EventListener<E> listener) {
        this.listeners.computeIfAbsent(eventClass, key -> new ArrayList()).add(listener);
    }

    @Override
    public synchronized <E extends IWizardryEvent> boolean fire(E event) {
        List<EventListener<? extends IWizardryEvent>> eventListeners = this.listeners.get(event.getClass());
        if (eventListeners != null) {
            for (EventListener<? extends IWizardryEvent> listener : eventListeners) {
                listener.onEvent(event);
            }
        }
        return event.canBeCanceled() && event.isCanceled();
    }
}

