/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.gametest;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.blockentity.ArcaneWorkbenchBlockEntity;
import com.binaris.wizardry.content.item.BlankScrollItem;
import com.binaris.wizardry.content.item.CrystalItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.content.item.WizardArmorItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.core.gametest.GST;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4516;

public final class ArcaneWorkbenchTest {
    private static final class_2338 WORKBENCH_POS = new class_2338(1, 2, 1);
    private static final class_243 PLAYER_POS = new class_243(1.5, 2.0, 1.5);

    public static void applySpellsToWand(class_4516 helper, class_1792 wand, Spell ... spells) {
        class_1799 wandStack;
        WandItem wandItem;
        block4: {
            block3: {
                if (!(wand instanceof WandItem)) break block3;
                wandItem = (WandItem)wand;
                if (spells.length != 0) break block4;
            }
            helper.method_35995("Invalid parameters for applySpellsToWand test.");
            return;
        }
        class_1799 finalWandStack = wandStack = wand.method_7854();
        List<Spell> validSpells = Arrays.stream(spells).filter(s -> wandItem.getTier((class_1799)finalWandStack).level >= s.getTier().level).toList();
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        for (int i = 0; i < validSpells.size(); ++i) {
            ctx.workbench.method_5447(i, SpellUtil.spellBookItem(validSpells.get(i)));
        }
        ctx.menu.onApplyButtonPressed(ctx.player);
        wandStack = ctx.workbench.method_5438(9);
        List<Spell> wandSpells = WandHelper.getSpells(wandStack);
        validSpells.forEach(spell -> GST.assertTrue(helper, "Wand %s should contain %s spell after applying.".formatted(wandItem, spell), wandSpells.contains(spell)));
    }

    public static void canUpgradeToNextTier(class_4516 helper, class_1792 wand) {
        if (!(wand instanceof WandItem)) {
            helper.method_35995("Invalid parameters for canUpgradeToNextTier test.");
            return;
        }
        WandItem wandItem = (WandItem)wand;
        class_1799 wandStack = wand.method_7854();
        if (wandItem.getTier(wandStack) == SpellTiers.MASTER) {
            return;
        }
        SpellTier nextTier = wandItem.getTier(wandStack).next();
        WandHelper.setProgression(wandStack, nextTier.getProgression());
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.method_5447(10, SpellUtil.arcaneTomeItem(nextTier));
        ctx.menu.onApplyButtonPressed(ctx.player);
        wandStack = ctx.workbench.method_5438(9);
        GST.assertEquals(helper, "Wand should upgrade to next tier.", nextTier, ((WandItem)wandStack.method_7909()).getTier(wandStack));
        GST.assertEmpty(helper, "Upgrade item should be consumed.", ctx.workbench.method_5438(10));
    }

    public static void putSpellOnBlankScroll(class_4516 helper, Spell spell) {
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, EBItems.BLANK_SCROLL.get().method_7854());
        ctx.workbench.method_5447(0, SpellUtil.spellBookItem(spell));
        ctx.workbench.method_5447(8, new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 10));
        ctx.menu.onApplyButtonPressed(ctx.player);
        class_1799 scroll = ctx.workbench.method_5438(9);
        Spell resultSpell = SpellUtil.getSpell(scroll);
        GST.assertFalse(helper, "Scroll should not be blank or empty: " + String.valueOf(scroll), scroll.method_7960() || scroll.method_7909() instanceof BlankScrollItem);
        GST.assertEquals(helper, "Scroll should contain " + String.valueOf(spell) + " spell.", spell, resultSpell);
        GST.assertTrue(helper, "Crystals should only be partially consumed.", ctx.workbench.method_5438(8).method_7947() < 10);
    }

    public static void putSpellOnScrollFilled(class_4516 helper) {
        class_1799 scroll = SpellUtil.setSpell(EBItems.SCROLL.get().method_7854(), Spells.FIREBALL);
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, scroll);
        ctx.workbench.method_5447(0, SpellUtil.spellBookItem(Spells.ICE_SHARD));
        ctx.workbench.method_5447(8, new class_1799((class_1935)EBItems.MAGIC_CRYSTAL.get(), 10));
        ctx.menu.onApplyButtonPressed(ctx.player);
        scroll = ctx.workbench.method_5438(9);
        GST.assertFalse(helper, "Scroll should not be blank or empty: " + String.valueOf(scroll), scroll.method_7960() || scroll.method_7909() instanceof BlankScrollItem);
        GST.assertFalse(helper, "Crystals shouldn't be consumed.", ctx.workbench.method_5438(8).method_7960());
        GST.assertEquals(helper, "Scroll should still contain original spell.", Spells.FIREBALL, SpellUtil.getSpell(scroll));
        helper.method_36036();
    }

    public static void upgradeNormalArmor(class_4516 helper, class_1792 armor, class_1792 upgradeItem) {
        if (!(armor instanceof WizardArmorItem)) {
            helper.method_35995("Invalid parameters for upgradeNormalArmor test.");
            return;
        }
        WizardArmorItem wizardArmorItem = (WizardArmorItem)armor;
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, armor.method_7854());
        ctx.workbench.method_5447(10, upgradeItem.method_7854());
        ctx.menu.onApplyButtonPressed(ctx.player);
        WizardArmorItem upgradedArmor = (WizardArmorItem)ctx.workbench.method_5438(9).method_7909();
        GST.assertTrue(helper, "Armor %s changed equipment slot after upgrade %s".formatted(armor, upgradeItem), upgradedArmor.method_7685() == wizardArmorItem.method_7685());
        GST.assertTrue(helper, "Armor %s should be upgraded after applying upgrade item %s.".formatted(armor, upgradeItem), upgradedArmor.getWizardArmorType() != WizardArmorType.WIZARD);
        GST.assertEmpty(helper, "Upgrade item should be consumed.", ctx.workbench.method_5438(10));
    }

    public static void cannotUpgradeMaxedArmor(class_4516 helper, class_1792 armor, class_1792 upgradeItem) {
        if (!(armor instanceof WizardArmorItem)) {
            helper.method_35995("Invalid parameters for cannotUpgradeMaxedArmor test.");
            return;
        }
        WizardArmorItem wizardArmorItem = (WizardArmorItem)armor;
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, armor.method_7854());
        ctx.workbench.method_5447(10, upgradeItem.method_7854());
        ctx.menu.onApplyButtonPressed(ctx.player);
        WizardArmorItem upgradedArmor = (WizardArmorItem)ctx.workbench.method_5438(9).method_7909();
        GST.assertTrue(helper, "Armor %s should not be upgraded further after applying upgrade item %s.".formatted(armor, upgradeItem), upgradedArmor.getWizardArmorType() == wizardArmorItem.getWizardArmorType());
        GST.assertNotEmpty(helper, "Upgrade item should not be consumed.", ctx.workbench.method_5438(10));
    }

    public static void repairWand(class_4516 helper, class_1792 wand, class_1792 crystal) {
        if (!(wand instanceof WandItem) || !(crystal instanceof CrystalItem)) {
            helper.method_35995("Invalid parameters for repairWand test.");
            return;
        }
        class_1799 wandStack = wand.method_7854();
        wandStack.method_7974(120);
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.method_5447(8, crystal.method_7854());
        ctx.menu.onApplyButtonPressed(ctx.player);
        wandStack = ctx.workbench.method_5438(9);
        GST.assertTrue(helper, "Wand %s should be repaired after applying crystal %s.".formatted(wand, crystal), wandStack.method_7919() < 120);
        GST.assertTrue(helper, "Crystal %s should be consumed after repairing wand %s.".formatted(crystal, wand), ctx.workbench.method_5438(8).method_7960());
    }

    public static void cannotExceedBlankScrollLimit(class_4516 helper) {
        class_1799 blankScrolls = new class_1799((class_1935)EBItems.BLANK_SCROLL.get(), 64);
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, class_1799.field_8037);
        ctx.workbench.method_5447(9, new class_1799((class_1935)EBItems.BLANK_SCROLL.get(), 16));
        ctx.player.method_31548().method_7394(blankScrolls);
        int playerSlotIndex = -1;
        for (int i = 11; i < ctx.menu.field_7761.size(); ++i) {
            if (ctx.menu.method_7611(i).method_7677().method_7909() != EBItems.BLANK_SCROLL.get()) continue;
            playerSlotIndex = i;
            break;
        }
        GST.assertTrue(helper, "Player should have blank scrolls in inventory", playerSlotIndex != -1);
        int initialPlayerCount = ctx.menu.method_7611(playerSlotIndex).method_7677().method_7947();
        class_1799 result = ctx.menu.method_7601(ctx.player, playerSlotIndex);
        int finalCentreCount = ctx.workbench.method_5438(9).method_7947();
        int finalPlayerCount = ctx.menu.method_7611(playerSlotIndex).method_7677().method_7947();
        GST.assertTrue(helper, "Centre slot should not exceed 16 blank scrolls", finalCentreCount <= 16);
        GST.assertTrue(helper, "Player inventory should still have blank scrolls if limit reached", finalPlayerCount > 0 || initialPlayerCount <= 16);
        helper.method_36036();
    }

    public static void cannotExceedSpellBookLimit(class_4516 helper, Spell spell) {
        class_1799 wandStack = EBItems.NOVICE_HEALING_WAND.get().method_7854();
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.method_5447(0, SpellUtil.spellBookItem(spell));
        class_1799 spellBooks = SpellUtil.spellBookItem(spell);
        spellBooks.method_7939(64);
        ctx.player.method_31548().method_7394(spellBooks);
        int playerSlotIndex = -1;
        for (int i = 11; i < ctx.menu.field_7761.size(); ++i) {
            class_1799 slotItem = ctx.menu.method_7611(i).method_7677();
            if (!(slotItem.method_7909() instanceof SpellBookItem) || SpellUtil.getSpell(slotItem) != spell) continue;
            playerSlotIndex = i;
            break;
        }
        GST.assertTrue(helper, "Player should have spell books in inventory", playerSlotIndex != -1);
        int initialPlayerCount = ctx.menu.method_7611(playerSlotIndex).method_7677().method_7947();
        ctx.menu.method_7601(ctx.player, playerSlotIndex);
        int finalSlot0Count = ctx.workbench.method_5438(0).method_7947();
        GST.assertTrue(helper, "Spell book slot should not exceed 1 item", finalSlot0Count <= 1);
        int totalSpellBooks = 0;
        for (int i = 0; i < 8; ++i) {
            class_1799 slotItem = ctx.workbench.method_5438(i);
            if (!(slotItem.method_7909() instanceof SpellBookItem)) continue;
            totalSpellBooks += slotItem.method_7947();
            GST.assertTrue(helper, "Each spell book slot should not exceed 1 item", slotItem.method_7947() <= 1);
        }
        helper.method_36036();
    }

    public static void cannotExceedUpgradeLimit(class_4516 helper, class_1792 upgradeItem) {
        class_1799 wandStack = EBItems.ADVANCED_EARTH_WAND.get().method_7854();
        TestContext ctx = ArcaneWorkbenchTest.setupTest(helper, wandStack);
        ctx.workbench.method_5447(10, new class_1799((class_1935)upgradeItem, 1));
        class_1799 upgrades = new class_1799((class_1935)upgradeItem, 64);
        ctx.player.method_31548().method_7394(upgrades);
        int playerSlotIndex = -1;
        for (int i = 11; i < ctx.menu.field_7761.size(); ++i) {
            if (ctx.menu.method_7611(i).method_7677().method_7909() != upgradeItem) continue;
            playerSlotIndex = i;
            break;
        }
        GST.assertTrue(helper, "Player should have upgrade items in inventory", playerSlotIndex != -1);
        int initialPlayerCount = ctx.menu.method_7611(playerSlotIndex).method_7677().method_7947();
        ctx.menu.method_7601(ctx.player, playerSlotIndex);
        int finalUpgradeCount = ctx.workbench.method_5438(10).method_7947();
        int finalPlayerCount = ctx.menu.method_7611(playerSlotIndex).method_7677().method_7947();
        GST.assertTrue(helper, "Upgrade slot should not exceed 1 item", finalUpgradeCount <= 1);
        GST.assertTrue(helper, "Player inventory should still have upgrade items if limit reached", finalPlayerCount == initialPlayerCount - (finalUpgradeCount == 1 ? 0 : 1));
        helper.method_36036();
    }

    private static TestContext setupTest(class_4516 helper, class_1799 centerItem) {
        ArcaneWorkbenchBlockEntity workbench = (ArcaneWorkbenchBlockEntity)helper.method_36014(WORKBENCH_POS);
        GST.assertNotNull(helper, "Arcane Workbench BlockEntity is null", (Object)workbench);
        class_1657 player = GST.mockServerPlayer(helper, PLAYER_POS);
        assert (workbench != null);
        workbench.method_5447(9, centerItem);
        ArcaneWorkbenchMenu menu = new ArcaneWorkbenchMenu(0, player.method_31548(), (class_1263)workbench);
        player.field_7512 = menu;
        return new TestContext(workbench, player, menu);
    }

    private ArcaneWorkbenchTest() {
    }

    private record TestContext(ArcaneWorkbenchBlockEntity workbench, class_1657 player, ArcaneWorkbenchMenu menu) {
    }
}

