/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.integrations.accessories;

import com.binaris.wizardry.api.content.item.ArtefactItem;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.core.IArtefactEffect;
import com.binaris.wizardry.core.integrations.accessories.AccessoriesIntegrationImpl;
import com.binaris.wizardry.core.platform.Services;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import org.jetbrains.annotations.Nullable;

public final class EBAccessoriesIntegration {
    private EBAccessoriesIntegration() {
    }

    public static boolean isAccessoriesLoaded() {
        return Services.PLATFORM.isModLoaded("accessories");
    }

    public static class_1792 getArtifact(class_1814 rarity, IArtefactEffect effect) {
        if (!EBAccessoriesIntegration.isAccessoriesLoaded()) {
            return new ArtefactItem(rarity, effect);
        }
        try {
            return AccessoriesIntegrationImpl.createAccessoryItem(rarity, effect);
        }
        catch (NoClassDefFoundError e) {
            return new ArtefactItem(rarity, effect);
        }
    }

    public static List<class_1799> getEquippedItems(class_1657 player) {
        if (EBAccessoriesIntegration.isAccessoriesLoaded()) {
            try {
                return AccessoriesIntegrationImpl.getEquippedItemsFromAccessories(player);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return InventoryUtil.getHotBarAndOffhand(player).stream().distinct().toList();
    }

    public static boolean isEquipped(class_1657 player, class_1792 item) {
        if (EBAccessoriesIntegration.isAccessoriesLoaded()) {
            try {
                return AccessoriesIntegrationImpl.isEquippedInAccessories(player, item);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return InventoryUtil.getHotBarAndOffhand(player).stream().anyMatch(stack -> stack.method_7909() == item);
    }

    @Nullable
    public static class_1799 getEquipped(class_1657 player, class_1792 item) {
        if (EBAccessoriesIntegration.isAccessoriesLoaded()) {
            try {
                return AccessoriesIntegrationImpl.getEquippedFromAccessories(player, item);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return InventoryUtil.getHotBarAndOffhand(player).stream().filter(stack -> stack.method_7909() == item).findFirst().orElse(null);
    }
}

