/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.networking;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.client.ParticleSpawner;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.NPCSpellCastS2C;
import com.binaris.wizardry.core.networking.s2c.ParticleBuilderS2C;
import com.binaris.wizardry.core.networking.s2c.SpellCastS2C;
import com.binaris.wizardry.core.networking.s2c.SpellGlyphPacketS2C;
import com.binaris.wizardry.core.networking.s2c.SpellPropertiesSyncS2C;
import com.binaris.wizardry.core.networking.s2c.TestParticlePacketS2C;
import com.binaris.wizardry.core.platform.Services;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public final class ClientMessageHandler {
    public static void spellCast(SpellCastS2C m) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            return;
        }
        class_1297 e = level.method_8469(m.getCasterID());
        if (!(e instanceof class_1657)) {
            return;
        }
        class_1657 caster = (class_1657)e;
        m.getSpell().cast(new PlayerCastContext((class_1937)level, caster, m.getHand(), 0, m.getModifiers()));
        SpellCastEvent.Source source = SpellCastEvent.Source.OTHER;
        class_1792 item = caster.method_5998(m.getHand()).method_7909();
        if (item instanceof WandItem) {
            source = SpellCastEvent.Source.WAND;
        } else if (item instanceof ScrollItem) {
            source = SpellCastEvent.Source.SCROLL;
        }
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(source, m.getSpell(), (class_1309)caster, m.getModifiers()));
    }

    public static void npcSpellCast(NPCSpellCastS2C m) {
        class_1309 livingCaster;
        class_1297 target;
        class_1297 caster;
        class_638 level;
        block8: {
            block7: {
                class_310 minecraft = class_310.method_1551();
                level = minecraft.field_1687;
                if (level == null) {
                    return;
                }
                caster = level.method_8469(m.getCasterID());
                class_1297 class_12972 = target = m.getTargetID() == -1 ? null : level.method_8469(m.getTargetID());
                if (!(caster instanceof class_1309)) break block7;
                livingCaster = (class_1309)caster;
                if (target instanceof class_1309) break block8;
            }
            return;
        }
        class_1309 livingTarget = (class_1309)target;
        m.getSpell().cast(new EntityCastContext((class_1937)level, livingCaster, m.getHand(), 0, livingTarget, m.getModifiers()));
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, m.getSpell(), livingCaster, m.getModifiers()));
        if (caster instanceof ISpellCaster) {
            ISpellCaster spellCaster = (ISpellCaster)caster;
            if (!m.getSpell().isInstantCast() || m.getSpell() instanceof NoneSpell) {
                spellCaster.setContinuousSpell(m.getSpell());
                spellCaster.setSpellCounter(m.getSpell() instanceof NoneSpell ? 0 : 1);
            } else {
                spellCaster.setSpellCounter(0);
            }
        }
    }

    public static void testParticle(TestParticlePacketS2C m) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        class_746 player = minecraft.field_1724;
        if (level == null || player == null) {
            return;
        }
        level.method_8406((class_2394)class_2398.field_11221, (double)m.getPos().method_10263() + 0.5, (double)m.getPos().method_10264() + 0.5, (double)m.getPos().method_10260() + 0.5, 0.0, 0.0, 0.0);
        player.method_43496((class_2561)class_2561.method_43470((String)("Test particle at " + String.valueOf(m.getPos()) + " with color " + m.getColor())));
    }

    public static void spellGlyph(SpellGlyphPacketS2C m) {
        if (GlyphClientHandler.INSTANCE.getGlyphData() == null) {
            GlyphClientHandler.INSTANCE.setGlyphData(new SpellGlyphData());
        }
        ClientUtils.handleGlyphDataPacket(m);
    }

    public static void spellPropertiesSync(SpellPropertiesSyncS2C m) {
        for (Map.Entry<class_2960, SpellProperties> entry : m.getPropertiesMap().entrySet()) {
            Optional<Spell> spell = Optional.ofNullable(Services.REGISTRY_UTIL.getSpell(entry.getKey()));
            if (spell.isEmpty()) {
                EBLogger.warn("Received spell properties for unknown spell: {}", entry.getKey());
                continue;
            }
            spell.get().setProperties(entry.getValue());
        }
    }

    public static void particleBuilder(ParticleBuilderS2C m) {
        ParticleSpawner.spawnClientParticle(m.getData());
    }
}

