/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.core.platform;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.core.platform.services.INetworkHelper;
import com.binaris.wizardry.core.platform.services.IObjectData;
import com.binaris.wizardry.core.platform.services.IPlatformHelper;
import com.binaris.wizardry.core.platform.services.IRegistryUtil;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IObjectData OBJECT_DATA = Services.load(IObjectData.class);
    public static final INetworkHelper NETWORK_HELPER = Services.load(INetworkHelper.class);
    public static final IRegistryUtil REGISTRY_UTIL = Services.load(IRegistryUtil.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        EBLogger.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

