/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.core.EBConfig;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;

public final class EBLootTables {
    private static final Set<class_2960> LOOT_TABLES = Sets.newHashSet();
    public static final class_2960 DUNGEON_ADDITIONS = EBLootTables.register("chests/dungeon_additions");
    public static final class_2960 DISPENSER_ADDITIONS = EBLootTables.register("chests/jungle_dispenser_additions");
    public static final class_2960 JUNK_FISHING_ADDITIONS = EBLootTables.register("gameplay/fishing/junk_additions");
    public static final class_2960 TREASURE_FISHING_ADDITIONS = EBLootTables.register("gameplay/fishing/treasure_additions");
    public static final class_2960 SUBSET_ARCANE_TOMES = EBLootTables.register("subsets/arcane_tomes");
    public static final class_2960 SUBSET_ARMOR_UPGRADES = EBLootTables.register("subsets/armor_upgrades");
    public static final class_2960 SUBSET_ELEMENTAL_CRYSTALS = EBLootTables.register("subsets/elemental_crystals");
    public static final class_2960 SUBSET_EPIC_ARTEFACTS = EBLootTables.register("subsets/epic_artefacts");
    public static final class_2960 SUBSET_RARE_ARTEFACTS = EBLootTables.register("subsets/rare_artefacts");
    public static final class_2960 SUBSET_UNCOMMON_ARTEFACTS = EBLootTables.register("subsets/uncommon_artefacts");
    public static final class_2960 SUBSET_WIZARD_ARMOR = EBLootTables.register("subsets/wizard_armor");
    public static final class_2960 SUBSET_WAND_UPGRADES = EBLootTables.register("subsets/wand_upgrades");
    public static final class_2960 SHRINE = EBLootTables.register("chests/shrine");
    private static final List<Pair<class_2960, class_55>> LOOT_INJECTIONS = new ArrayList<Pair<class_2960, class_55>>();

    private EBLootTables() {
    }

    private static class_2960 register(String location) {
        return EBLootTables.register(WizardryMainMod.location(location));
    }

    private static class_2960 register(class_2960 location) {
        if (LOOT_TABLES.add(location)) {
            return location;
        }
        throw new IllegalArgumentException(String.valueOf(location) + " is already a registered built-in loot table");
    }

    public static void initInjections() {
        Arrays.stream(EBConfig.lootInjectionLocations).forEach(location -> LOOT_INJECTIONS.add((Pair<class_2960, class_55>)Pair.of((Object)location, (Object)EBLootTables.createAdditivePool(DUNGEON_ADDITIONS, 1))));
        LOOT_INJECTIONS.add((Pair<class_2960, class_55>)Pair.of((Object)new class_2960("chests/gameplay/fishing/junk"), (Object)EBLootTables.createAdditivePool(JUNK_FISHING_ADDITIONS, 4)));
        LOOT_INJECTIONS.add((Pair<class_2960, class_55>)Pair.of((Object)new class_2960("chests/gameplay/fishing/treasure"), (Object)EBLootTables.createAdditivePool(TREASURE_FISHING_ADDITIONS, 4)));
        LOOT_INJECTIONS.add((Pair<class_2960, class_55>)Pair.of((Object)new class_2960("chests/jungle_temple_dispenser"), (Object)EBLootTables.createAdditivePool(DISPENSER_ADDITIONS, 1)));
        if (!EBConfig.injectMobDrops) {
            return;
        }
        class_7923.field_41177.forEach(entityType -> {
            class_2960 lootTable = entityType.method_16351();
            class_2960 entityName = class_7923.field_41177.method_10221(entityType);
            if (Arrays.asList(EBConfig.modifiableMobs).contains(entityName)) {
                LOOT_INJECTIONS.add((Pair<class_2960, class_55>)Pair.of((Object)lootTable, (Object)EBLootTables.createAdditivePool(WizardryMainMod.location("entities/mob_additions"), 1)));
            } else if (!entityType.method_5891().method_6136()) {
                LOOT_INJECTIONS.add((Pair<class_2960, class_55>)Pair.of((Object)lootTable, (Object)EBLootTables.createAdditivePool(WizardryMainMod.location("entities/mob_additions"), 1)));
            }
        });
    }

    public static void applyInjections(BiConsumer<class_2960, class_55> injector) {
        if (LOOT_INJECTIONS.isEmpty()) {
            EBLootTables.initInjections();
        }
        LOOT_INJECTIONS.forEach(loot -> injector.accept((class_2960)loot.getFirst(), (class_55)loot.getSecond()));
    }

    private static class_55 createAdditivePool(class_2960 entry, int weight) {
        return class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)entry).method_437(weight).method_436(0)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_35509((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)).method_355();
    }
}

