/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.RegisterFunction;
import com.binaris.wizardry.content.spell_tier.AdvancedTier;
import com.binaris.wizardry.content.spell_tier.ApprenticeTier;
import com.binaris.wizardry.content.spell_tier.MasterTier;
import com.binaris.wizardry.content.spell_tier.NoviceTier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2378;

public final class SpellTiers {
    public static Map<String, SpellTier> TIERS = new HashMap<String, SpellTier>();
    public static final SpellTier NOVICE = SpellTiers.tier("novice", NoviceTier::new);
    public static final SpellTier APPRENTICE = SpellTiers.tier("apprentice", ApprenticeTier::new);
    public static final SpellTier ADVANCED = SpellTiers.tier("advanced", AdvancedTier::new);
    public static final SpellTier MASTER = SpellTiers.tier("master", MasterTier::new);

    private SpellTiers() {
    }

    public static void registerNull(RegisterFunction<SpellTier> function) {
        SpellTiers.register(null, function);
    }

    public static void register(class_2378<?> registry, RegisterFunction<SpellTier> function) {
        TIERS.forEach((id, tier) -> function.register((class_2378<SpellTier>)registry, WizardryMainMod.location(id), (SpellTier)tier));
    }

    static SpellTier tier(String name, Supplier<SpellTier> tierSupplier) {
        SpellTier tier = tierSupplier.get();
        tier.setLocation(WizardryMainMod.location(name));
        TIERS.put(name, tier);
        return tier;
    }

    public static SpellTier getNextByLevel(int level) {
        for (SpellTier tier : TIERS.values()) {
            if (tier.level != level) continue;
            return tier;
        }
        return null;
    }
}

