/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.setup.registries.client;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.client.model.BoulderModel;
import com.binaris.wizardry.client.model.IceGiantModel;
import com.binaris.wizardry.client.model.RemnantModel;
import com.binaris.wizardry.client.model.WizardModel;
import com.binaris.wizardry.client.model.armor.RobeArmorModel;
import com.binaris.wizardry.client.model.armor.WizardArmorModel;
import com.binaris.wizardry.client.renderer.entity.BlankRenderer;
import com.binaris.wizardry.client.renderer.entity.BoulderRenderer;
import com.binaris.wizardry.client.renderer.entity.BubbleRenderer;
import com.binaris.wizardry.client.renderer.entity.ConjureArrowRenderer;
import com.binaris.wizardry.client.renderer.entity.DecayRenderer;
import com.binaris.wizardry.client.renderer.entity.EvilWizardRenderer;
import com.binaris.wizardry.client.renderer.entity.FireRingRenderer;
import com.binaris.wizardry.client.renderer.entity.ForceArrowRenderer;
import com.binaris.wizardry.client.renderer.entity.IceGiantRenderer;
import com.binaris.wizardry.client.renderer.entity.IceSpikeRenderer;
import com.binaris.wizardry.client.renderer.entity.MagicArrowRenderer;
import com.binaris.wizardry.client.renderer.entity.MagicProjectileRenderer;
import com.binaris.wizardry.client.renderer.entity.MeteorRenderer;
import com.binaris.wizardry.client.renderer.entity.RemnantRenderer;
import com.binaris.wizardry.client.renderer.entity.SigilRenderer;
import com.binaris.wizardry.client.renderer.entity.WizardRenderer;
import com.binaris.wizardry.client.renderer.entity.ZombieSpawnerRenderer;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1545;
import net.minecraft.class_2960;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_878;
import net.minecraft.class_945;
import net.minecraft.class_953;
import org.jetbrains.annotations.NotNull;

public final class EBRenderers {
    private static final Map<DeferredObject<class_1299<? extends class_1297>>, class_5617<?>> providers = Maps.newHashMap();

    private EBRenderers() {
    }

    public static void createEntityLayers(BiConsumer<class_5601, Supplier<class_5607>> consumer) {
        consumer.accept(WizardArmorModel.LAYER_LOCATION, WizardArmorModel::createBodyLayer);
        consumer.accept(RobeArmorModel.LAYER_LOCATION, RobeArmorModel::createBodyLayer);
        consumer.accept(RemnantModel.LAYER_LOCATION, RemnantModel::createBodyLayer);
        consumer.accept(WizardModel.LAYER_LOCATION, WizardModel::createBodyLayer);
        consumer.accept(IceGiantModel.LAYER_LOCATION, IceGiantModel::createBodyLayer);
        consumer.accept(BoulderModel.LAYER_LOCATION, BoulderModel::createBodyLayer);
    }

    public static void registerRenderers() {
        EBRenderers.registerEntityRender(EBEntities.METEOR, MeteorRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ARROW_RAIN, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FIRE_BOMB, class_953::new);
        EBRenderers.registerEntityRender(EBEntities.FIRE_BOMB, class_953::new);
        EBRenderers.registerEntityRender(EBEntities.SPARK_BOMB, class_953::new);
        EBRenderers.registerEntityRender(EBEntities.POISON_BOMB, class_953::new);
        EBRenderers.registerEntityRender(EBEntities.SMOKE_BOMB, class_953::new);
        EBRenderers.registerEntityRender(EBEntities.THUNDERBOLT, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.MAGIC_MISSILE, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.DART, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_SHARD, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.LIGHTNING_ARROW, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_LANCE, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FORCE_ARROW, ForceArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.CONJURED_ARROW, ConjureArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FLAME_CATCHER_ARROW, MagicArrowRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.BLIZZARD, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_SPICKES, IceSpikeRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.TORNADO, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.BUBBLE, BubbleRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.HAILSTORM, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.DECAY, DecayRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.REMNANT, RemnantRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.WIZARD, WizardRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.EVIL_WIZARD, EvilWizardRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ICE_GIANT, IceGiantRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.FIRE_BOLT, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/firebolt.png")));
        EBRenderers.registerEntityRender(EBEntities.SPARK, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/spark.png")));
        EBRenderers.registerEntityRender(EBEntities.ICE_CHARGE, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/ice_charge.png")));
        EBRenderers.registerEntityRender(EBEntities.MAGIC_FIREBALL, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/magic_fireball.png")));
        EBRenderers.registerEntityRender(EBEntities.ICE_BALL, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/iceball.png")));
        EBRenderers.registerEntityRender(EBEntities.DARKNESS_ORB, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/darkness_orb.png"), true));
        EBRenderers.registerEntityRender(EBEntities.FORCE_ORB, ctx -> new MagicProjectileRenderer(ctx, WizardryMainMod.location("textures/entity/force_orb.png"), true));
        EBRenderers.registerEntityRender(EBEntities.RING_OF_FIRE, ctx -> new FireRingRenderer(ctx, WizardryMainMod.location("textures/entity/ring_of_fire.png")));
        EBRenderers.registerEntityRender(EBEntities.FIRE_SIGIL, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/fire_sigil.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.FROST_SIGIL, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/frost_sigil.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.LIGHTNING_SIGIL, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/lightning_sigil.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.HEAL_AURA, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/healing_aura.png"), 0.3f, true));
        EBRenderers.registerEntityRender(EBEntities.COMBUSTION_RUNE, ctx -> new SigilRenderer(ctx, WizardryMainMod.location("textures/entity/combustion_rune.png"), 0.0f, true));
        EBRenderers.registerEntityRender(EBEntities.MAGIC_SLIME, class_945::new);
        EBRenderers.registerEntityRender(EBEntities.LIGHTNING_WRAITH, ctx -> new class_878(ctx){

            @NotNull
            public class_2960 method_3881(@NotNull class_1545 entity) {
                return WizardryMainMod.location("textures/entity/lightning_wraith.png");
            }
        });
        EBRenderers.registerEntityRender(EBEntities.ICE_WRAITH, ctx -> new class_878(ctx){

            @NotNull
            public class_2960 method_3881(@NotNull class_1545 entity) {
                return WizardryMainMod.location("textures/entity/ice_wraith.png");
            }
        });
        EBRenderers.registerEntityRender(EBEntities.SHADOW_WRAITH, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.STORM_ELEMENTAL, BlankRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.BOULDER, BoulderRenderer::new);
        EBRenderers.registerEntityRender(EBEntities.ZOMBIE_SPAWNER, ZombieSpawnerRenderer::new);
    }

    public static Map<DeferredObject<class_1299<? extends class_1297>>, class_5617<?>> getRenderers() {
        return providers;
    }

    private static <T extends class_1297> void registerEntityRender(DeferredObject<class_1299<T>> entityType, class_5617 provider) {
        providers.put(entityType, provider);
    }
}

